img = imread('skull.tif');
% Cast the input image in double with a range from 0 to 1
img = double(img);
img = img ./ max(img(:));
 
dimY = size(img,1);
dimX = size(img,2);
 
figure
imshow(img,[])
title('Input Image')
 
% Computation of the gradient module
[FX,FY] = gradient(double(img));
gradModule = sqrt((FX.^2)+(FY.^2));
 
figure
imshow(gradModule,[])
title('Gradient Module')
 
imgGFuzzy4 = zeros(dimY, dimX);
 
gradiente4 = readfis('gradiente4.fis')
 
% Analysis of every pixel
for i = 2 : dimY-1
    fprintf('Column %i of %i \n', i, dimY-1)
    for j = 2 : dimX-1
        imgGFuzzy4(i,j) = evalfis([img(i-1, j), img(i, j-1), img(i+1, j), img(i, j+1)], gradiente4);
    end
end
 
figure
imshow(imgGFuzzy4,[])
title('Fuzzy Gradient 4')
