#include <time.h>
#include "solutionpool.h"
#include "randomsolution.h"
#include "random.h"
#include "localsearch.h"


bool update_diverse_set (solution_t* px, int n, solutionpool_t* pD)
{
  return false;
}


void recombine_solutions (solution_t *px1, solution_t *px2, data_t *pI, solution_t *px)
{
  /*
    Put in x all points that belong to both x1 and x2
    Build a vector including in the first half the points of x1 \setminus x2 and in the second half the points of x2 \setminus x1
    Alternatively extract a point from the first half and a point from the second half of the vector, overwriting them,
      and add them to x
  */
}


void scatter_search(data_t* pI, solution_t* px, char* visit_strategy, double tauMax, int nb, int nd, long* pseed)
{
  /*
    B := \emptyset; D := \emptyset; P := \emptyset
    While Time() \leq \tau_{\max} do
      While |P| < n_{B}+n_{D} do
        x := RandomSolution(I);
        x := SteepestAscent(x);
        If x \notin P then P := P \cup {x};
      EndWhile
      For each x \in P do
        If x \notin B then B := UpdateBestSet(B,x);
        If x \notin B then D := UpdateDiverseSet(D,x);
      EndFor
      For each (x,y) \in B \times (B \cup D) do
       P := P \cup Recombine(x,y,I);
      EndFor
    EndWhile
    x* := \arg\max f_{x \in B} f(x);
    Return (x*,f*);
  */
  solutionpool_t B, D, P;
  solution_t x;
  int iter;
  time_t start;
  bool insert;
  int s, s2;


  start = clock();
  create_solutionpool(nb,&B);
  create_solutionpool(nd,&D);
  create_solutionpool(nb*(nb+nd),&P);

  create_solution(pI->n,&x);

  while (((double)clock() - start) / CLOCKS_PER_SEC < tauMax)
  {
    /* Build or integrate the candidate population */
    while (P.card < nb + nd)
    {
      generate_random_solution(pI,&x,pseed);
      steepest_ascent(pI,&x,visit_strategy,&iter);
      if (!is_in_solutionpool(&x,pI->n,&P))
      {
        add_solution_to_pool(&x,pI->n,&P);
      }
      clean_solution(&x,pI->n);
    }

    /* Test the candidate solutions for insertion in the reference set */
    for (s = 1; s <= P.card; s++)
    {
      insert = update_best_set(P.S[s],pI->n,&B);
      if (!insert) insert = update_diverse_set(P.S[s],pI->n,&D);
    }
    clean_solutionpool(&P);

    /* Recombine the solutions in the reference set into candidate ones */
    for (s = 1; s <= B.card; s2++)
    {
      for (s2 = 1; s2 <= B.card; s2++)
        if (s != s2)
        {
          recombine_solutions(B.S[s],B.S[s2],pI,&x);
          add_solution_to_pool(&x,pI->n,&P);
        }

      for (s2 = 1; s2 <= D.card; s2++)
      {
        recombine_solutions(B.S[s],D.S[s2],pI,&x);
        add_solution_to_pool(&x,pI->n,&P);
      }
    }
  }

  if (nb > 0) copy_solution(B.S[1],px);

  destroy_solutionpool(&B);
  destroy_solutionpool(&D);
  destroy_solutionpool(&P);
}
