#include <time.h>
#include "randomsolution.h"
#include "scattersearch.h"
#include "localsearch.h"

void explore_neighbourhood_for_relinking (solution_t *px, solution_t *py, data_t *pI, char* visit_strategy, point *pp_in, point *pp_out, int *pdelta_f)
{
  point p_in, p_out;
  int delta_f;

  *pdelta_f = INT_MIN;
  *pp_in = *pp_out = NO_POINT;
  for (p_in = first_point_in(px); !end_point_list(p_in,px); p_in = next_point(p_in,px))
    if (!py->in_x[get_index(p_in,pI)])
      for (p_out = first_point_out(px); !end_point_list(p_out,px); p_out = next_point(p_out,px))
        if (py->in_x[get_index(p_out,pI)])
        /* Note: It would be more efficient to scan p_out in py and check that it is not in px */
        {
          delta_f = evaluate_exchange(p_in,p_out,px,pI);
          if (delta_f > *pdelta_f)
          {
            *pdelta_f = delta_f;
            *pp_in = p_in;
            *pp_out = p_out;
            /* if ( (delta_f > 0) && (strcmp(visit_strategy,"-fb") == 0) ) break; (Presently, we use "-gb") */
          }
        }
}

/* Find the path relinking solution px to solution py with a steepest_ascent procedure
   that minimizes the Hamming distance to y and the objective,
   and return the best solution z along the path with respect to the objective */
void find_relinking_solution (solution_t *px, solution_t *py, data_t *pI, char *visit_strategy, solution_t *pz)
{
  solution_t z;
  point p_in, p_out;
  int delta_f;

  create_solution(pI->n,&z);
  copy_solution(px,&z);

  clean_solution(pz,pI->n);
  do
  {
    explore_neighbourhood_for_relinking(&z,py,pI,visit_strategy,&p_in,&p_out,&delta_f);
    if (p_in != NO_POINT)
    {
      swap_points(p_in,p_out,&z,pI);
      if (z.f > pz->f) copy_solution(&z,pz);
    }

  } while (p_in != NO_POINT);
}


void path_relinking (data_t* pI, solution_t* px, char* visit_strategy, double tauMax, int nb, long* pseed)
{
  solutionpool_t B, P;
  solution_t x;
  int iter;
  time_t start;
  int s, s2;

  start = clock();
  create_solution(pI->n,&x);
  create_solutionpool(nb,&B);
  create_solutionpool(nb*(nb-1),&P);

  while (((double)clock() - start) / CLOCKS_PER_SEC < tauMax)
  {
    /* Build or integrate the candidate population */
    while (P.card < nb)
    {
      clean_solution(&x,pI->n);
      generate_random_solution(pI,&x,pseed);
      steepest_ascent(pI,&x,visit_strategy,&iter);
      if (!is_in_solutionpool(&x,pI->n,&P)) add_solution_to_pool(&x,pI->n,&P);
    }

    /* Test the candidate solutions for insertion in the reference set */
    for (s = 1; s <= P.card; s++)
      update_best_set(P.S[s],pI->n,&B);
    clean_solutionpool(&P);

    /* Recombine the solutions in the reference set into candidate ones */
    for (s = 1; s <= B.card; s++)
    {
      /*if (((double)clock() - start) / CLOCKS_PER_SEC > tauMax) break;*/
      for (s2 = 1; s2 <= B.card; s2++)
        if (s != s2)
        {
          clean_solution(&x,pI->n);
          find_relinking_solution(B.S[s],B.S[s2],pI,"-gb",&x);
          steepest_ascent(pI,&x,visit_strategy,&iter);
          if (!is_in_solutionpool(&x,pI->n,&P)) add_solution_to_pool(&x,pI->n,&P);
        }
    }
  }
  if (B.card > 0) copy_solution(B.S[1],px);

  destroy_solution(&x);
  destroy_solutionpool(&B);
  destroy_solutionpool(&P);
}
