#include "vns.h"
#include "localsearch.h"
#include "random.h"


/* Perturbate solution *px by an amount s using the random seed *pseed */
void shaking (data_t *pI, solution_t *px, int s, long *pseed)
{
  int *Indices;
  int i, i_in, i_out, temp;


  /* Build a vector with the indices of the internal points in the first k positions
     and the indices of the external point in the last n-k positions */
  Indices = int_alloc(pI->n+1);
  i_in = 1; i_out = pI->n;
  for (i = 1; i <= pI->n; i++)
    if (px->in_x[i] == true)
      Indices[i_in++] = i;
    else
      Indices[i_out--] = i;

  /* Select s internal points and move their indices to the first s positions of Indices */
  for (i_in = 1; i_in <= s; i_in++)
  {
    i = rand_int(i_in,pI->k,pseed);
    temp = Indices[i_in];
    Indices[i_in] = Indices[i];
    Indices[i] = temp;
  }

  /* Select s external points and move their indices to the last s positions of Indices */
  for (i_out = pI->n; i_out >= pI->n-s+1; i_out--)
  {
    i = rand_int(pI->k+1,i_out,pseed);
    temp = Indices[i_out];
    Indices[i_out] = Indices[i];
    Indices[i] = temp;
  }

  /* Perform s exchanges between the first and the last points of Indices */
  for (i_in = 1, i_out = pI->n; i_in <= s; i_in++, i_out--)
    swap_points(get_point(Indices[i_in],pI),get_point(Indices[i_out],pI),px,pI);

  free(Indices);
}


/* Apply the Variable Neighbourhood Search to instance I starting from solution x for niter iterations,
   with parameter s_min, delta_s and s_max, using the given random seed */
void variable_neighborhood_search (data_t *pI, solution_t *px, char *visit_strategy, int niter,
                                   int s_min, int delta_s, int s_max, long *pseed)
{
  int iter, tot_iter;
  solution_t x_star;
  int s;


  truncated_steepest_ascent(pI,px,visit_strategy,niter,&iter);
  tot_iter = iter;

  create_solution(pI->n,&x_star);
  copy_solution (px,&x_star);

  s = s_min;
  while (tot_iter < niter)
  {
    shaking(pI,px,s,pseed);
    truncated_steepest_ascent(pI,px,visit_strategy,niter-tot_iter,&iter);
    tot_iter += iter;

    if (px->f > x_star.f)
    {
      copy_solution(px,&x_star);
      s = s_min;
    }
    else
    {
      s += delta_s;
      if (s > s_max) s = s_min;
    }
  }
  copy_solution(&x_star,px);
}
