﻿#include <limits.h>
#include "localsearch.h"


/* Evaluate the exchange of points p_in (exiting) and p_out (entering) in solution x (without performing it explicitly) */
int evaluate_exchange (point p_in, point p_out, solution_t *px, data_t *pI)
{
  int delta;

  delta  = px->D[get_index(p_out,pI)];
  delta -= px->D[get_index(p_in,pI)];
  delta -= pI->d[get_index(p_in,pI)][get_index(p_out,pI)];

  return delta;
}


/* Explore the single-swap neighbourhood of solution x with visit_strategy and return the best pair of points (p_in,p_out)
   to exchange and the resulting variation delta_f of the objective */
void explore_neighbourhood (solution_t *px, data_t *pI, char* visit_strategy, point *pp_in, point *pp_out, int *pdelta_f)
{
  point p_in, p_out;
  int delta_f;

  *pdelta_f = INT_MIN;
  *pp_in = *pp_out = NO_POINT;
  for (p_in = first_point_in(px); !end_point_list(p_in,px); p_in = next_point(p_in,px))
    for (p_out = first_point_out(px); !end_point_list(p_out,px); p_out = next_point(p_out,px))
    {
      delta_f = evaluate_exchange(p_in,p_out,px,pI);
      if (delta_f > *pdelta_f)
      {
        *pdelta_f = delta_f;
        *pp_in = p_in;
        *pp_out = p_out;
        if ( (delta_f > 0) && (strcmp(visit_strategy,"-fb") == 0) ) break;
      }
    }
}


/* Apply the steepest ascent heuristic to instance *pI and solution *px with the given visit_strategy;
   return the number of iterations *pniter */
void steepest_ascent (data_t *pI, solution_t *px, char *visit_strategy, int *pniter)
{
/*
  Stop := false;
  While Stop = false do
    \tilde{x} := \arg\max_{x' \in N(x)} f(x');
    If f (\tilde{x}) ≤ f (x) then Stop := true; else x := \tilde{x};
  EndWhile;
*/
  point p_in, p_out;
  int delta_f;

  *pniter = 0;
  do
  {
    explore_neighbourhood(px,pI,visit_strategy,&p_in,&p_out,&delta_f);
    if (delta_f > 0)
    {
      swap_points(p_in,p_out,px,pI);
      (*pniter)++;
    }

  } while (delta_f > 0);
}
