#ifndef __DATA_H
#define __DATA_H


#include "defs.h"
#include "alloc.h"


typedef struct data_s
 {
  int n;   /* cardinality of the set of points P */
  int k;   /* cardinality of the feasible instances x \in X */
  int **d; /* distance matrix between the points */
 } data_t;


/* Load from the AMPL file data_file the instance *pI */
void load_data (char *data_file, data_t *I);

/* Deallocate the instance *pI */
void destroy_data (data_t *I);

/* Print the instance *pI in AMPL format */
void print_data (data_t *I);


/* Types and functions to convert points and indices */

typedef int point;
#define point_alloc int_alloc
#define NO_POINT -1

/* Get the index of point p in instance *pI */
int get_index (point i, data_t *pI);

/* Get the point of index id in instance *pI */
point get_point (int id, data_t *pI);

#endif /* __DATA_H */
