#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "greedy.h"


void parse_command_line (int argc, char *argv[], char *data_file, char *param);


int main (int argc, char *argv[])
{
  char data_file[NAME_LENGTH];
  data_t I;
  solution_t x;
  char param[NAME_LENGTH];
  time_t start, end;
  double CPUtime;
  int id;


  parse_command_line(argc,argv,data_file,param);

  load_data(data_file,&I);
  /*print_data(&I); */

  create_solution(I.n,&x);

  start = clock();
  if (strcmp(param,"-g") == 0)
    greedy(&I,&x);
  else if (strcmp(param,"-gf") == 0)
    greedy_farthest(&I,&x);
  else if (strcmp(param,"-gp") == 0)
    greedy_farthestpair(&I,&x);
  else if (strcmp(param,"-ga") == 0)
    greedy_tryall(&I,&x);
  else if (strcmp(param, "-s") == 0)
  {
    for (id = 1; id <= I.n; id++)
      add_point(get_point(id,&I),&x,&I);
    stingy(&I,&x);
  }
  end = clock();
  CPUtime = (double) (end - start) / CLOCKS_PER_SEC;

  printf("%s ",data_file);
  printf("%10.6f ",CPUtime);
  print_sorted_solution(&x,I.n);
  printf("\n");

  destroy_solution(&x);
  destroy_data(&I);

  return EXIT_SUCCESS;
}


void print_usage (char *command)
{
  fprintf(stderr,"Use: %s [datafile] [-g|-gf|-gp|-ga|-s]\n",command);
  fprintf(stderr,"datafile: name and path of data file\n");
  fprintf(stderr,"-g:       basic greedy heuristic\n");
  fprintf(stderr,"-gf:      greedy heuristic starting from the farthest point\n");
  fprintf(stderr,"-gp:      greedy heuristic starting from the farthest pair of points\n");
  fprintf(stderr,"-ga:      greedy heuristic starting from all points\n");
  fprintf(stderr,"-s:       basic stingy heuristic\n");
}


void parse_command_line (int argc, char *argv[], char *data_file, char *param)
{
  if (argc != 3)
  {
    print_usage(argv[0]);
    exit(EXIT_FAILURE);
  }

  strcpy(data_file,argv[1]);
  strcpy(param,argv[2]);
}
