#ifndef __SOLUTIONPOOL_H
#define __SOLUTIONPOOL_H


#include "solution.h"

typedef struct solutionpool_s
{
  int card;         /* current number of solutions */
  int size;         /* maximum number of solutions */
  solution_t **S;   /* vector of pointers to solutions */

} solutionpool_t;


/* Create an empty solution pool of size n */
void create_solutionpool (int n, solutionpool_t *pSP);

/* Deallocate a solution pool */
void destroy_solutionpool (solutionpool_t *pSP);

/* Remove all current solutions from pool SP */
void clean_solutionpool (solutionpool_t *pSP);

/* Print pool SP of solutions of size n */
void print_solutionpool (solutionpool_t* pSP, int n);

/* Determines whether solution x, of size n, belongs to pool SP */
bool is_in_solutionpool (solution_t *px, int n, solutionpool_t* pSP);

/* Add a copy of solution px, of size n, to pool SP as the last element */
void add_solution_to_pool (solution_t *px, int n, solutionpool_t* pSP);

/* Add solution x, of size n, to pool SP (sorted by decreasing objective value), avoiding duplicates */
bool update_best_set (solution_t* px, int n, solutionpool_t* pSP);

#endif /* __SOLUTIONPOOL_H */
