﻿#include <time.h>

#include "random.h"
#include "localsearch.h"


void generate_random_solution (data_t* pI, solution_t* px, long* pseed)
{
  int* index;
  int i, num;

  index = int_alloc(pI->n+1);
  for (i = 1; i <= pI->n; i++)
    index[i] = i;

  num = 0;
  while (num < pI->k)
  {
    i = rand_int(1,pI->n-num,pseed);
    add_point(get_point(index[i],pI),px,pI);
    index[i] = index[pI->n-num];
    num++;
  }

  free(index);
}


void random_restart (data_t* pI, solution_t* px, char* visit_strategy, double tauMax, long* pseed)
{
	solution_t x;
	int iter;
	time_t start;


	start = clock();
	create_solution(pI->n,&x);
	while (((double)clock() - start) / CLOCKS_PER_SEC < tauMax)
	{
    clean_solution(&x, pI->n);
    generate_random_solution(pI,&x,pseed);
		steepest_ascent(pI,&x,visit_strategy,&iter);
		if (x.f > px->f) copy_solution(&x,px);
	}
}
