#ifndef _ran1_h
#define _ran1_h

#define IA 16807
#define IM 2147483647
#define AM (1.0/IM)
#define IQ 127773
#define IR 2836
#define NTAB 32
#define NDIV (1+(IM-1)/NTAB)
#define EPS 1.2e-7
#define RNMX (1.0-EPS)


double ran1 (long *idum);

/* Extract a random integer between iMin and iMax (included) with uniform probability */
int rand_int (int iMin, int iMax, long* idum);

/* Extract a random index between iMin and iMax (included) with probabilities given by the elements of vector pi */
int rand_index (int iMin, int iMax, double *pi, long *seed);

/* Generate and assign to the element of integer vector v, between index s and index e random uniform values between v_min and v_max */
void generate_random_int_vector (int *v, int s, int e, int v_min, int v_max, long *pseed);

/* Randomly permute the values of integer vector v between index s and index e */
void permute_int_vector (int *v, int s, int e, long *pseed);

#endif
