#ifndef __EXCHANGE_H
#define __EXCHANGE_H

#include "data.h"
#include "solution.h"

/* Apply the steepest ascent heuristic to instance *pI and solution *px with the given visit_strategy;
  return the number of iterations *pniter */
void steepest_ascent (data_t *pI, solution_t *px, char *visit_strategy, int *pniter);

/* Apply the steepest ascent heuristic to instance *pI and solution *px with the given visit_strategy
  without exceeding the given maximum number of iterations max_iter; return the number of iterations *pniter */
void truncated_steepest_ascent (data_t *pI, solution_t *px, char *visit_strategy, int max_iter, int *pniter);

/* Evaluate the exchange of points p_in (exiting) and p_out (entering) in solution x (without performing it explicitly) */
int evaluate_exchange (point p_in, point p_out, solution_t* px, data_t* pI);

#endif /* __EXCHANGE_H */
