#include "solutionpool.h"


/* Create an empty solution pool of size n */
void create_solutionpool (int n, solutionpool_t *pSP)
{
  pSP->card = 0;
  pSP->size = n;
  pSP->S = (solution_t **) calloc(n+1,sizeof(solution_t *));
  if (pSP->S == NULL)
  {
    fprintf(stderr,"Not enough memory to allocate a vector of %d pointers to solution_t!\n",n+1);
    exit(EXIT_FAILURE);
  }

}

/* Deallocate a solution pool */
void destroy_solutionpool (solutionpool_t *pSP)
{
  pSP->card = pSP->size = 0;
  free(pSP->S);
  pSP->S = NULL;
}

/* Remove all current solutions from pool SP */
void clean_solutionpool (solutionpool_t *pSP)
{
  while (pSP->card > 0)
  {
    destroy_solution(pSP->S[pSP->card]);
    pSP->S[pSP->card] = NULL;
    pSP->card--;
  }
}

/* Print pool SP of solutions of size n */
void print_solutionpool (solutionpool_t* pSP, int n)
{
  int s;

  for (s = 1; s <= pSP->card; s++)
    print_sorted_solution(pSP->S[s],n);
}

/* Determines whether solution x, of size n, belongs to pool SP */
/* NOTA: SE IL POOL E' ORDINATO RISPETTO A f, SI PUO' USARE LA RICERCA BINARIA */
bool is_in_solutionpool (solution_t* px, int n, solutionpool_t* pSP)
{
  int s, i;

  for (s = 1; s <= pSP->card; s++)
    if (px->f == pSP->S[s]->f)
    {
      for (i = 1; i <= n; i++)
        if (px->in_x[i] != pSP->S[s]->in_x[i]) break;

      if (i > n) break;
    }

  return (s <= pSP->card);
}


/* Add a copy of solution px, of size n, to pool SP as the last element */
void add_solution_to_pool (solution_t* px, int n, solutionpool_t* pSP)
{
  if (pSP->card < pSP->size)
  {
    pSP->S[++pSP->card] = (solution_t *) malloc(sizeof(solution_t));
    if (pSP->S[pSP->card] == NULL)
    {
      fprintf(stderr,"Not enough memory to allocate a solution!\n");
      exit(EXIT_FAILURE);
    }

    create_solution(n,pSP->S[pSP->card]);
    copy_solution(px,pSP->S[pSP->card]);
  }
}


/* Add solution x, of size n, to pool SP (sorted by decreasing objective value), avoiding duplicates */
bool update_best_set (solution_t* px, int n, solutionpool_t* pSP)
{
  int s;

  if (is_in_solutionpool(px,n,pSP)) return false;

  for (s = pSP->card; (s > 0) && (px->f > pSP->S[s]->f); s--)
    if (s < pSP->size)
      pSP->S[s+1] = pSP->S[s];
    else
      free(pSP->S[s]);

  if (s < pSP->size)
  {
    pSP->S[s+1] = (solution_t *) malloc(sizeof(solution_t));
    if (pSP->S[s+1] == NULL)
    {
      fprintf(stderr,"Not enough memory to allocate a solution!\n");
      exit(EXIT_FAILURE);
    }
    create_solution(n,pSP->S[s+1]);
    copy_solution(px,pSP->S[s+1]);

    if (pSP->card < pSP->size) pSP->card++;
  }

  return (s < pSP->size);
}
