#include "tabusearch.h"
#include "localsearch.h"
#include "alloc.h"

bool is_tabu (point p_in, point p_out, data_t *pI, int iter, int *T, int l_in, int l_out, int f, int f_star)
{
  if (f > f_star) /* A move improving the best known result is nontabu (aspiration criterium) */
    return false;
  else
    return ((iter <= T[get_index(p_in,pI)] + l_out) || (iter <= T[get_index(p_out,pI)] + l_in));
}


void explore_neighbourhood_with_tabu (solution_t* px, data_t* pI, char* visit_strategy, int iter, int* T, int l_in, int l_out, int fstar,
                                      point *pp_in, point *pp_out, int *pdelta_f)
{
  point p_in, p_out;
  int delta_f;

  *pdelta_f = INT_MIN;
  *pp_in = *pp_out = NO_POINT;
  for (p_in = first_point_in(px); !end_point_list(p_in,px); p_in = next_point(p_in,px))
    for (p_out = first_point_out(px); !end_point_list(p_out,px); p_out = next_point(p_out,px))
    {
      delta_f = evaluate_exchange(p_in,p_out,px,pI);
      if ( (delta_f > *pdelta_f) && (!is_tabu(p_in,p_out,pI,iter,T,l_in,l_out,px->f+delta_f,fstar)) )
      {
        *pdelta_f = delta_f;
        *pp_in = p_in;
        *pp_out = p_out;
        if ( (delta_f > 0) && (strcmp(visit_strategy,"-fb") == 0) ) break;
      }
    }
}


void tabu_search (data_t *pI, solution_t *px, char *visit_strategy, int niter, int l_in, int l_out)
{
  point p_in, p_out;
  int delta_f;
  solution_t x_star;
  int *T;
  int i;
  int iter;


  create_solution(pI->n,&x_star);
  copy_solution(px,&x_star);

  T = int_alloc(pI->n+1);
  for (i = 1; i <= pI->n; i++)
    T[i] = INT_MIN;

  for (iter = 1; iter <= niter; iter++)
  {
    explore_neighbourhood_with_tabu(px,pI,visit_strategy,iter,T,l_in,l_out,x_star.f,&p_in,&p_out,&delta_f);
    if (p_in != NO_POINT)
    {
      swap_points(p_in,p_out,px,pI);
      T[get_index(p_in,pI)] = T[get_index(p_out,pI)] = iter;
      if (px->f > x_star.f) copy_solution(px,&x_star);
    }
  }

  free(T);

  copy_solution(&x_star,px);
}
