#include "data.h"

/* Look for string s in the open file pointed by fp;
   if Rewind = true, restart from the beginning of the file.  */
bool find_token (FILE *fp, char *s, bool Rewind)
{
  char s2[NAME_LENGTH];

  if (Rewind == true) rewind(fp);
  while (fscanf(fp,"%s",s2) != EOF)
  {
    if (strcmp(s,s2) == 0) return true;
  }
  return false;
}

/* Load from the AMPL file data_file the instance *pI */
void load_data (char *data_file, data_t *pI)
{
  FILE *fp;
  int i, j, ii, jj, d;
  char s[NAME_LENGTH];


  fp = fopen(data_file,"r");
  if (fp == NULL)
  {
    fprintf(stderr,"File %s could not be opened!\n",data_file);
    exit(EXIT_FAILURE);
  }

  if (find_token(fp,"n",true) == false)
  {
    fprintf(stderr,"File %s does not provide n!\n",data_file);
    exit(EXIT_FAILURE);
  }
  fscanf(fp,"%*s %d",&pI->n);
  pI->d = int2_alloc(pI->n+1,pI->n+1);

  if (find_token(fp,"k",true) == false)
  {
    fprintf(stderr,"File %s does not provide k!\n",data_file);
    exit(EXIT_FAILURE);
  }
  fscanf(fp,"%*s %d",&pI->k);

  if (find_token(fp,"D",true) == false)
  {
    fprintf(stderr,"File %s does not provide D!\n",data_file);
    exit(EXIT_FAILURE);
  }
  fscanf(fp,"%*s");
  for (ii = 1; ii <= pI->n; ii++)
    for (jj = 1; jj <= pI->n; jj++)
    {
      fscanf(fp,"%s",s);
      sscanf(s,"[%d,%d]",&i,&j);
      fscanf(fp," %d",&d);
      pI->d[i][j] = d;
    }
}

/* Deallocate the instance *pI */
void destroy_data (data_t *pI)
{
  int i;

  for (i = 0; i < pI->n; i++)
    free(pI->d[i]);
  free(pI->d);
  pI->d = NULL;
  pI->n = pI->k = 0;
}

/* Print the instance *pI in AMPL format */
void print_data (data_t *pI)
{
  int i, j;

  printf("param n := %d ;\n\n",pI->n);
  printf("param k := %d ;\n\n",pI->k);
  printf("param D :=\n");
  for (i = 1; i <= pI->n; i++)
  {
    for (j = 1; j <= pI->n; j++)
      printf("[%d,%d] %d ",i,j,pI->d[i][j]);
    printf("\n");
  }
  printf(";\n\n");
  printf("end;\n");
}

/* Get the index of point p in instance *pI */
int get_index (point i, data_t *pI)
{
  return (int) i;
}

/* Get the point of index id in instance *pI */
point get_point (int id, data_t *pI)
{
  return (point) id;
}
