#include "grasp.h"
#include "random.h"


int compute_selection_criterium (solution_t *px, data_t *pI, int *phi, point *P)
{
  point i;
  int cnt;

  cnt = 0;
  for (i = first_point_out(px); !end_point_list(i,px); i = next_point(i,px))
  {
    cnt++;
    phi[cnt] = dist_from_x(i,px,pI);
    P[cnt] = i;
  }

  return cnt;
}


/* Extract at random a point from P with a bias in favour of large phi */
point biased_random_extraction (point *P, int *phi, int num, double mu, long *pseed)
{
  int phiMin, phiMax;
  int cnt;
  double barphi;
  int RCLsize;


  /* find the minimum and maximum value of the selection criterium */
  phiMin = INT_MAX;
  phiMax = -1;
  for (cnt = 1; cnt <= num; cnt++)
  {
    if (phi[cnt] < phiMin) phiMin = phi[cnt];
    if (phi[cnt] > phiMax) phiMax = phi[cnt];
  }

  /* compute the threshold */
  barphi = (1-mu) * phiMax + mu * phiMin;

  /* distinguish the RCL elements from the other points */
  RCLsize = 0;
  for (cnt = 1; cnt <= num; cnt++)
    if (phi[cnt] >= barphi)
    {
      RCLsize++;
      P[RCLsize] = P[cnt];
    }

  /* generate a random number */
  cnt = rand_int(1,RCLsize,pseed);

  /* choose an element of the RCL based on the random number */
  return P[cnt];
}


point biased_random_point_to_add (solution_t *px, data_t *pI, double mu, long *pseed)
{
  point i;
  int *phi;
  point *P;
  int num;


  /* if px is empty, choose a point at random uniformly */
  if (get_card(px) == 0)
    i = get_point(rand_int(1,pI->n,pseed),pI);
  else
  /* otherwise apply the value-based RCL approach with parameter mu */
  {
    phi = int_alloc(pI->n+1);
    P = point_alloc(pI->n+1);

    /* compute the values of the selection criterium */
    num = compute_selection_criterium(px,pI,phi,P);

    /* Extract at random a point from P with a bias in favour of large phi */
    i = biased_random_extraction(P,phi,num,mu,pseed);

    free(phi);
    free(P);
  }

  return i;
}


void grasp (data_t *pI, solution_t *px, int iterations, double mu, long *pseed)
{
  solution_t x;
  int iter;
  point i;


  create_solution(pI->n,&x);
  for (iter = 1; iter <= iterations; iter++)
  {
    while (get_card(&x) < pI->k)
    {
      i = biased_random_point_to_add(&x,pI,mu,pseed);
      add_point(i,&x,pI);
    }
    if (x.f > px->f) copy_solution(&x,px);
    clean_solution(&x,pI->n);
  }

  destroy_solution(&x);
}
