#include <limits.h>
#include "greedy.h"


point best_point_to_add (solution_t *px, data_t *pI)
{
  point i, iMax;
  int d, dMax;


  iMax = NO_POINT;
  dMax = -1;
  for (i = first_point_out(px); !end_point_list(i,px); i = next_point(i,px))
  {
    d = dist_from_x(i,px,pI);
    if (d > dMax)
    {
      dMax = d;
      iMax = i;
    }
  }

  return iMax;
}


void greedy (data_t *pI, solution_t *px)
{
  point i;

  while (get_card(px) < pI->k)
  {
    i = best_point_to_add(px,pI);
    add_point(i,px,pI);
  }
}


void farthest_pair (data_t *pI, point *piIn, point *pjIn)
{
  int dMax;
  int i, j;

  *piIn = *pjIn = NO_POINT;
  dMax = -1;
  for (i = 1; i <= pI->n; i++)
    for (j = i+1; j <= pI->n; j++)
      if (pI->d[i][j] > dMax)
      {
        dMax = pI->d[i][j];
        *piIn = i;
        *pjIn = j;
      }
}


void greedy_farthestpair (data_t *pI, solution_t *px)
{
  point iIn, jIn;

  farthest_pair(pI,&iIn,&jIn);
  add_point(iIn,px,pI);
  add_point(jIn,px,pI);
  greedy(pI,px);
}


point best_initial_point (data_t *pI)
{
  int i, j;
  int d, dMax;
  point iMax;


  dMax = -1;
  for (i = 1; i <= pI->n; i++)
  {
    d = 0;
    for (j = 1; j <= pI->n; j++)
      d += pI->d[i][j];

    if (d > dMax)
    {
      dMax = d;
      iMax = i;
    }
  }

  return iMax;
}


void greedy_farthest (data_t *pI, solution_t *px)
{
  point iIn;

  iIn = best_initial_point(pI);
  add_point(iIn,px,pI);
  greedy(pI,px);
}


void greedy_tryall (data_t *pI, solution_t *px)
{
  solution_t x;
  int id;


  create_solution(pI->n,&x);
  for (id = 1; id <= pI->n; id++)
  {
    add_point(get_point(id,pI),&x,pI);
    greedy(pI,&x);

    if (x.f > px->f) copy_solution(&x,px);
    if (id < pI->n) clean_solution(&x,pI->n);
  }

  destroy_solution(&x);
}


point best_point_to_delete (solution_t *px, data_t *pI)
{
  point i, iMin;
  int d, dMin;


  dMin = INT_MAX;
  iMin = NO_POINT;
  for (i = first_point_in(px); !end_point_list(i,px); i = next_point(i,px)) 
  {
    d = dist_from_x(i,px,pI);                                               
    if (d < dMin)
    {
      dMin = d;
      iMin = i;
    }
  }

  return iMin;
}


void stingy (data_t *pI, solution_t *px)   
{
  point i;

  while (get_card(px) > pI->k)          
  {
    i = best_point_to_delete(px,pI);    
    delete_point(i,px,pI);              
  }
}







