#include "alloc.h"

/* Allocate a vector of n int */
int *int_alloc (int n)
{
  int *v = (int *) calloc(n,sizeof(int));
  if (v == NULL)
  {
    fprintf(stderr,"Not enough memory to allocate a vector of %d int!",n);
    exit(EXIT_FAILURE);
  }
  return v;
}

/* Allocate a vector of n pint */
pint *pint_alloc (int n)
{
  pint *v = (pint *) calloc(n,sizeof(pint));
  if (v == NULL)
  {
    fprintf(stderr,"Not enough memory to allocate a vector of %d int*!",n);
    exit(EXIT_FAILURE);
  }
  return v;
}

/* Allocate a matrix of (n1,n2) int */
int **int2_alloc (int n1, int n2)
{
  int i, **m = pint_alloc(n1);
  for (i = 0; i < n1; i++)
    m[i] = int_alloc(n2);
  return m;
}

/* Allocate a vector of n bool */
bool *bool_alloc (int n)
{
  bool *v = (bool *) calloc(n,sizeof(bool));
  if (v == NULL)
  {
    fprintf(stderr,"Not enough memory to allocate a vector of %d bool!",n);
    exit(EXIT_FAILURE);
  }
  return v;
}


/* Allocate a vector of n double */
double *double_alloc (int n)
{
  double *v = (double *) calloc(n,sizeof(double));
  if (v == NULL)
  {
    fprintf(stderr,"Not enough memory to allocate a vector of %d double!",n);
    exit(EXIT_FAILURE);
  }
  return v;
}
