/* stampa_quadrati.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define EXIT_COMMANDLINE 1
#define EXIT_FILEACCESS  2
#define EXIT_MEMORY      3
#define EXIT_FILEFORMAT  4

#define LUNGHEZZA 255


void InterpretaParametri (int argc, char *argv[], char *FileDati);

void StampaAiuto (char *nome);


int main (int argc, char *argv[])
{
  char FileDati[LUNGHEZZA+1];
  FILE *stream;
  int i;


  /* Interpreta la linea di comando e determina il numero di file da creare */
  InterpretaParametri(argc,argv,FileDati);

  /* Crea il file dei dati, se indicato, oppure specifica che la stampa va a video */
  if (strcmp(FileDati,"") == 0)
    stream = stdout;
  else
  {
    stream = fopen(FileDati,"w");
    if (stream == NULL)
    {
      fprintf(stderr,"Impossibile creare il file %s!\n",FileDati);
      exit(EXIT_FILEACCESS);
    }
  }

  /* Calcola e stampa i quadrati dei primi 10 numeri */
  for (i = 1; i <= 10; i++)
    fprintf(stream,"%d ",i*i);

  /* Chiude il file dei dati, se indicato */
  if (strcmp(FileDati,"") != 0) fclose(stream);

  return EXIT_SUCCESS;
}


/* Interpreta la linea i comando e determina il numero su cui operare */
void InterpretaParametri (int argc, char *argv[], char *FileDati)
{
  if (argc > 2)
  {
    fprintf(stderr,"Numero di parametri errato!\n");
    StampaAiuto(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  if (argc == 1)
    strcpy(FileDati,"");
  else
    strcpy(FileDati,argv[1]);
}


/* Stampa un messaggio che spiega l'uso del programma */
void StampaAiuto (char *nome)
{
  fprintf(stderr,"Il formato corretto e':\n");
  fprintf(stderr,"%s [nomefile]\n",nome);
  fprintf(stderr,"- nomefile: nome del file contenente i dati (se assente, stampa a video)\n");
}
