/* riga.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define EXIT_COMMANDLINE 1
#define EXIT_FILEACCESS  2
#define EXIT_MEMORY      3
#define EXIT_FILEFORMAT  4

#define LUNGHEZZA 255


void InterpretaParametri (int argc, char *argv[], char *FileDati);

void StampaAiuto (char *nome);


int main (int argc, char *argv[])
{
  char FileDati[LUNGHEZZA+1];
  FILE *fFileDati;
  char s1[LUNGHEZZA+1];
  char s2[LUNGHEZZA+1];
  char s3[LUNGHEZZA+1];
  char c1, c2;


  /* Interpreta la linea di comando e determina il numero di file da creare */
  InterpretaParametri(argc,argv,FileDati);

  /* Apre il file dei dati */
  fFileDati = fopen(FileDati,"r");
  if (fFileDati == NULL)
  {
    fprintf(stderr,"Impossibile creare il file %s!\n",FileDati);
    exit(EXIT_FILEACCESS);
  }

  /* Legge la prima riga con fgets(s,LUNGHEZZA,fFileDati) COMPRESO il carattere '\n' e la assegna a s */
  fgets(s1,LUNGHEZZA,fFileDati);

  /* Legge la seconda riga con fscanf(fp,"%[^\n]",s) e assegna a s un'intera riga ESCLUSO il carattere '\n' */
  fscanf(fFileDati,"%[^\n]",s2);

  /* Legge il primo carattere successivo. Si provi a commentare
     l'istruzione: la fscanf successiva fallisce immediatamente. */
  fscanf(fFileDati,"%c",&c1);

  /* Legge la terza riga con fscanf(fp,"%[^\n]\n",s) compreso il carattere '\n', ma non lo assegna a s */
  fscanf(fFileDati,"%[^\n]\n",s3);

  /* Legge il primo carattere successivo */
  fscanf(fFileDati,"%c",&c2);

  /* Chiude il file dei dati */
  fclose(fFileDati);

  /* Stampa le tre righe */
  printf("Gli estremi di ogni riga sono delimitati dagli asterischi:\n");
  printf("1) *%s*\n",s1);
  printf("2) *%s*\n",s2);
  printf("Il primo carattere successivo e': %c (%d)\n",c1,(int) c1);
  printf("3) *%s*\n",s3);
  printf("Il primo carattere successivo e': %c (%d)\n",c2,(int) c2);

  return EXIT_SUCCESS;
}


/* Interpreta la linea i comando e determina il numero su cui operare */
void InterpretaParametri (int argc, char *argv[], char *FileDati)
{
  if (argc != 2)
  {
    fprintf(stderr,"Numero di parametri errato!\n");
    StampaAiuto(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  strcpy(FileDati,argv[1]);
}


/* Stampa un messaggio che spiega l'uso del programma */
void StampaAiuto (char *nome)
{
  fprintf(stderr,"Il formato corretto e':\n");
  fprintf(stderr,"%s nomefile\n",nome);
  fprintf(stderr,"nomefile: nome del file contenente i dati\n");
}
