/* creafile.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define EXIT_COMMANDLINE 1
#define EXIT_FILEACCESS  2

#define LUNGHEZZA 255


void InterpretaParametri (int argc, char *argv[], int *pn);

void StampaAiuto (char *nome);

void CreaFile (int n);


int main (int argc, char *argv[])
{
  int n;


  /* Interpreta la linea di comando e determina il numero di file da creare */
  InterpretaParametri(argc,argv,&n);

  CreaFile(n);

  return EXIT_SUCCESS;
}


/* Interpreta la linea di comando e determina il numero su cui operare */
void InterpretaParametri (int argc, char *argv[], int *pn)
{
  if (argc != 2)
  {
    fprintf(stderr,"Numero di parametri errato!\n");
    StampaAiuto(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  /* Se non  possibile convertire il parametro in un numero intero,
     segnala l'errore e stampa un messaggio con l'uso del programma */
  if (sscanf(argv[1],"%d",pn) != 1)
  {
    fprintf(stderr,"Il parametro non e' un numero intero!\n");
    StampaAiuto(argv[0]);
    exit(EXIT_COMMANDLINE);
  }
  else if (*pn < 0)
  {
    fprintf(stderr,"Il parametro e' un numero intero non positivo!\n");
    StampaAiuto(argv[0]);
    exit(EXIT_COMMANDLINE);
  }
}


/* Stampa un messaggio che spiega l'uso del programma */
void StampaAiuto (char *nome)
{
  fprintf(stderr,"Il formato corretto e':\n");
  fprintf(stderr,"%s n\n",nome);
  fprintf(stderr,"n: numero di file da creare (non negativo)\n",nome);
}


void CreaFile (int n)
{
  char s[LUNGHEZZA+1];
  FILE *fp;
  int i;

  for (i = 1; i <= n; i++)
  {
    sprintf(s,"prova%d.txt",i);
    //sprintf(s,"prova%3d.txt",i);
    //sprintf(s,"prova%03d.txt",i);
    fp = fopen(s,"w");
    if (fp == NULL)
    {
      fprintf(stderr,"Impossibile creare il file %s!\n",s);
      exit(EXIT_FILEACCESS);
    }
    fclose(fp);
  }
}
