/* data.c */

#include <stdio.h>
#include <stdlib.h>
#include "iocrema.h"
#include <string.h>

#define EXIT_WRONGPARAMETER 1
#define EXIT_NODATE         2


void InterpretaLineaComando (int argc, char *argv[], char *giorno, char *mese, char *anno);

int ConverteMeseInIntero (char *mese);


int main (int argc, char *argv[])
{
  char giorno[2+1], mese[9+1], anno[4+1];
  int m;


  InterpretaLineaComando(argc,argv,giorno,mese,anno);

  m = ConverteMeseInIntero(mese);

  StampaStringa(giorno);
  StampaStringa("/");
  StampaIntero(m);
  StampaStringa("/");
  StampaStringa(anno);

  return EXIT_SUCCESS;
}


void InterpretaLineaComando (int argc, char *argv[], char *giorno, char *mese, char *anno)
{
  if (argc != 4)
  {
    StampaStringa("Il formato corretto e' ");
    StampaStringa(argv[0]);
    StampaStringa(" giorno mese anno\n");
    exit(EXIT_WRONGPARAMETER);
  }

  strcpy(giorno,argv[1]);
  strcpy(mese,argv[2]);
  strcpy(anno,argv[3]);
}


int ConverteMeseInIntero (char *mese)
{
  int m;

  if (strcmp(mese,"gennaio") == 0)
    m = 1;
  else if (strcmp(mese,"febbraio") == 0)
    m = 2;
  else if (strcmp(mese,"marzo") == 0)
    m = 3;
  else if (strcmp(mese,"aprile") == 0)
    m = 4;
  else if (strcmp(mese,"maggio") == 0)
    m = 5;
  else if (strcmp(mese,"giugno") == 0)
    m = 6;
  else if (strcmp(mese,"luglio") == 0)
    m = 7;
  else if (strcmp(mese,"agosto") == 0)
    m = 8;
  else if (strcmp(mese,"settembre") == 0)
    m = 9;
  else if (strcmp(mese,"ottobre") == 0)
    m = 10;
  else if (strcmp(mese,"novembre") == 0)
    m = 11;
  else if (strcmp(mese,"dicembre") == 0)
    m = 12;
  else
  {
    StampaStringa("Il parametro 2 non corrisponde al nome di un mese!\n");
    exit(EXIT_NODATE);
  }

  return m;
}
