/* calcolo3.c */

#include <stdio.h>
#include <stdlib.h>
#include "iocrema.h"

#define EXIT_COMMANDLINE 1


typedef enum {FALSE = 0, TRUE = 1} boolean;


int quadrato (int n);

int cubo (int n);

void InterpretaParametri (int argc, char *argv[], boolean *pq,
                          int *pnq, boolean *pc, int *pnc);

void StampaAiuto (char *nome);


int main (int argc, char *argv[])
{
  boolean q, c;
  int nq, nc;


  /* Interpreta la linea di comando e determina il numero su cui operare */
  InterpretaParametri(argc,argv,&q,&nq,&c,&nc);

  /* Calcola e stampa il quadrato e/o il cubo del numero dato */
  if (q == TRUE)
  {
    StampaStringa("Il quadrato di ");
    StampaIntero(nq);
    StampaStringa(" e' ");
    StampaIntero(quadrato(nq));
    StampaStringa("\n");
  }

  if (c == TRUE)
  {
    StampaStringa("Il cubo di ");
    StampaIntero(nc);
    StampaStringa(" e' ");
    StampaIntero(cubo(nc));
    StampaStringa("\n");
  }

  return EXIT_SUCCESS;
}


/* Calcola il quadrato di un numero */
int quadrato (int n)
{
  return n * n;
}


/* Calcola il cubo di un numero */
int cubo (int n)
{
  return n * quadrato(n);
}


/* Interpreta la linea di comando e determina il numero su cui operare */
void InterpretaParametri (int argc, char *argv[], boolean *pq, int *pnq, boolean *pc, int *pnc)
{
  int p;


  if ( (argc != 3) && (argc != 5) )
  {
    StampaStringa("Numero di parametri errato!\n");
    StampaAiuto(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  /* Valori di default: a priori, suppone
     di non eseguire nessuna operazione */
  *pq = *pc = FALSE;

  /* Scorre i parametri nell'ordine:
     la linea di comando corretta alterna opzioni e dati numerici;
     si confronta il parametro corrente con le possibili opzioni,
     identificata l'opzione, si converte il parametro successivo in dato numerico */
  p = 1;
  while (p < argc)
  {
    if (strcmp(argv[p],"-q") == 0)
    {
      *pq = TRUE;
      p++;
      *pnq = ConverteStringaInIntero(argv[p]);
    }
    else if (strcmp(argv[p],"-c") == 0)
    {
      *pc = TRUE;
      p++;
      *pnc = ConverteStringaInIntero(argv[p]);
    }
    else
    {
      StampaStringa("Opzione non riconosciuta!\n");
      StampaAiuto(argv[0]);
      exit(EXIT_COMMANDLINE);
    }

    p++;
  }
}


/* Stampa un messaggio che spiega l'uso del programma */
void StampaAiuto (char *nome)
{
  StampaStringa("Il formato corretto e':\n");
  StampaStringa(nome);
  StampaStringa(" [-q n1] [-c n2]\n");
  StampaStringa("-q n1: calcola il quadrato del numero n1\n");
  StampaStringa("-c n2: calcola il cubo     del numero n2\n");
}
