/* calcolo1.c */

#include <stdio.h>
#include <stdlib.h>
#include "iocrema.h"

#define EXIT_COMMANDLINE 1


int quadrato (int n);

int cubo (int n);

void InterpretaLineaComando (int argc, char *argv[], int *pn);

void StampaAiuto (char *nome);


int main (int argc, char *argv[])
{
  int n;


  /* Interpreta la linea di comando e determina il numero su cui operare */
  InterpretaLineaComando(argc,argv,&n);

  /* Calcola e stampa il quadrato del numero dato */
  StampaStringa("Il quadrato di ");
  StampaIntero(n);
  StampaStringa(" e' ");
  StampaIntero(quadrato(n));
  StampaStringa("\n");

  /* Calcola e stampa il cubo del numero dato */
  StampaStringa("Il cubo di ");
  StampaIntero(n);
  StampaStringa(" e' ");
  StampaIntero(cubo(n));
  StampaStringa("\n");

  return EXIT_SUCCESS;
}


/* Calcola il quadrato di un numero */
int quadrato (int n)
{
  return n * n;
}


/* Calcola il cubo di un numero */
int cubo (int n)
{
  return n * quadrato(n);
}


/* Interpreta la linea di comando e determina il numero su cui operare */
void InterpretaLineaComando (int argc, char *argv[], int *pn)
{
  if (argc != 2)
  {
    StampaStringa("Numero di parametri errato!\n");
    StampaAiuto(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  *pn = ConverteStringaInIntero(argv[1]);
}


/* Stampa un messaggio che spiega l'uso del programma */
void StampaAiuto (char *nome)
{
  StampaStringa("Il formato corretto e':\n");
  StampaStringa(nome);
  StampaStringa(" n\n");
  StampaStringa("n: numero su cui operare\n");
}
