/* calcolo2.c */

#include <stdio.h>
#include <stdlib.h>
#include "iocrema.h"

#define EXIT_COMMANDLINE 1


typedef enum {QUADRATO, CUBO} boolean;


int quadrato (int n);

int cubo (int n);

void InterpretaLineaComando (int argc, char *argv[], operazione *po, int *pn);

void StampaAiuto (char *nome);


int main (int argc, char *argv[])
{
  operazione o;
  int n;


  /* Interpreta la linea di comando e determina il numero su cui operare */
  InterpretaLineaComando(argc,argv,&o,&n);

  /* Calcola e stampa il quadrato o il cubo del numero dato */
  if (o == QUADRATO)
  {
    StampaStringa("Il quadrato di ");
    StampaIntero(n);
    StampaStringa(" e' ");
    StampaIntero(quadrato(n));
    StampaStringa("\n");
  }
  else if (o == CUBO)
  {
    StampaStringa("Il cubo di ");
    StampaIntero(n);
    StampaStringa(" e' ");
    StampaIntero(cubo(n));
    StampaStringa("\n");
  }

  return EXIT_SUCCESS;
}


/* Calcola il quadrato di un numero */
int quadrato (int n)
{
  return n * n;
}


/* Calcola il cubo di un numero */
int cubo (int n)
{
  return n * quadrato(n);
}


/* Interpreta la linea di comando e determina il numero su cui operare */
void InterpretaLineaComando (int argc, char *argv[], operazione *po, int *pn)
{
  if (argc != 3)
  {
    StampaStringa("Numero di parametri errato!\n");
    StampaAiuto(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  /* Se l'opzione non e' ne' -q ne' -c segnala l'errore e stampa un messaggio con l'uso del programma */
  if ( (strcmp(argv[1],"-q") != 0) && (strcmp(argv[1],"-c") != 0) )
  {
    StampaStringa("Opzione non riconosciuta!\n");
    StampaAiuto(argv[0]);
    exit(EXIT_COMMANDLINE);
  }
  else if (strcmp(argv[1],"-q") == 0)
    *po = QUADRATO;
  else
    *po = CUBO;

  *pn = ConverteStringaInIntero(argv[2]);
}


/* Stampa un messaggio che spiega l'uso del programma */
void StampaAiuto (char *nome)
{
  StampaStringa("Il formato corretto e':\n");
  StampaStringa(nome);
  StampaStringa(" -q|-c n\n");
  StampaStringa("-q n: calcola il quadrato del numero n\n");
  StampaStringa("-c n: calcola il cubo     del numero n\n");
}
