/* selectionsort.c */

#include <stdio.h>
#include <stdlib.h>
#include "iocrema.h"


typedef int* vint;

void LeggeVettoreInteri (vint *pV, int *pn);

void StampaVettoreInteri (vint V, int n);

void SelectionSort (vint V, int n);


int main (int argc, char *argv[])
{
  vint V;
  int n;


  /* Legge la lunghezze e gli elementi del vettore */
  LeggeVettoreInteri(&V,&n);

  /* Ordina il vettore */
  SelectionSort(V,n);

  /* Stampa il vettore ordinato */
  StampaVettoreInteri(V,n);

  /* Dealloca il vettore (anche per controllare eventuali overflow) */
  free(V);

	 return EXIT_SUCCESS;
}


/* Chiede all'utente di indicare la lunghezza e gli elementi del vettore */
void LeggeVettoreInteri (vint *pV, int *pn)
{
  int i;

  StampaStringa("Quanti numeri interi si vogliono inserire? ");
  *pn = LeggeIntero();

  *pV = (vint) calloc(*pn+1,sizeof(int));

  // Legge i numeri da tastiera
  for (i = 1; i <= *pn; i++)
  {
    StampaStringa("V[");
    StampaIntero(i);
    StampaStringa("] = ");
    (*pV)[i] = LeggeIntero();
  }
  StampaStringa("\n\n");
}


/* Stampa il vettore */
void StampaVettoreInteri (vint V, int n)
{
  int i;

  for (i = 1; i <= n; i++)
  {
    StampaIntero(V[i]);
    StampaStringa(" ");
  }
  StampaStringa("\n");
}


/* Trova l'indice massimo del vettore V fra gli indici 1 e n */
int TrovaIndiceMassimo (vint V, int n)
{
  int i, iMax;

  iMax = 1;
  for (i = 2; i <= n; i++)
    if (V[i] > V[iMax]) iMax = i;

  return iMax;
}


/* Scambia i valori delle due variabili */
void Scambia (int *pa, int *pb)
{
  int temp;

  temp = *pa;
  *pa = *pb;
  *pb = temp;
}


/* Ordina il vettore V di estremi 1 e n con l'algoritmo di Selection Sort */
void SelectionSort (vint V, int n)
{
  int i;

  if (n > 1)
  {
    i = TrovaIndiceMassimo(V,n);
    Scambia(&V[i],&V[n]);
    SelectionSort(V,n-1);
  }
}
