/* modifyvect.c */

#include <stdio.h>
#include <stdlib.h>
#include "iocrema.h"

typedef int*  vint;

void StampaVettore (vint V, int n);

void CambiaSegno (vint V, int n);

void ScalaVettore (vint V, int n);

void ScalaVettorePerIndirizzo (vint *pV, int n);


int main (int argc, char *argv[])
{
  int i, n;
  vint V;


  StampaStringa("Indicare la lunghezza del vettore V: ");
  n = LeggeIntero();

  V = (vint) calloc(n+1,sizeof(int));
  if (V == NULL)
    StampaStringa("Memoria insufficiente per allocare V!\n");
  else
  {
    for (i = 1; i <= n; i++)
      V[i] = i;
    StampaVettore(V,n);

    StampaStringa("\n");

    StampaStringa("Eseguiamo CambiaSegno(V,n/2)\n");
    CambiaSegno(V,n/2);
    StampaVettore(V,n);

    StampaStringa("\n");

    StampaStringa("Eseguiamo V += n/2\n");
    V += n/2;
    StampaVettore(V,n);

    StampaStringa("\n");

    StampaStringa("Eseguiamo V -= n/2\n");
    V -= n/2;
    StampaVettore(V,n);

    StampaStringa("\n");

    StampaStringa("Eseguiamo ScalaVettore(V,n/2)\n");
    ScalaVettore(V,n/2);
    StampaVettore(V,n);

    StampaStringa("\n");

    StampaStringa("L'indirizzo di V ora e' ");
    StampaIndirizzo(V);
    StampaStringa("\n");

    StampaStringa("Eseguiamo ScalaVettorePerIndirizzo(&V,n/2)\n");
    ScalaVettorePerIndirizzo(&V,n/2);
    StampaVettore(V,n);

    StampaStringa("L'indirizzo di V ora e' ");
    StampaIndirizzo(V);
    StampaStringa("\n");

    StampaStringa("Riportiamo V all'indirizzo iniziale, per poterlo deallocare.\n");
    ScalaVettorePerIndirizzo(&V,-n/2);

    StampaStringa("L'indirizzo di V ora e' ");
    StampaIndirizzo(V);
    StampaStringa("\n");

    free(V);
  }

  return EXIT_SUCCESS;
}


/* Scambia il vettore di interi "V" dall'indice 1 all'indice "n" */
void StampaVettore (vint V, int n)
{
  int i;

  StampaStringa("[ ");
  for (i = 1; i <= n; i++)
  {
    StampaIntero(V[i]);
    StampaStringa(" ");
  }
  StampaStringa("]\n");
}


/* Cambia il segno degli elementi di V da 1 a n */
void CambiaSegno (vint V, int n)
{
  int i;

  for (i = 1; i <= n; i++)
    V[i] *= -1;
}


/* Cerca di scalare in avanti di "n" elementi il vettore "V" */
void ScalaVettore (vint V, int n)
{
  V += n;
}


/* Scala in avanti di "n" elementi il vettore "V" */
void ScalaVettorePerIndirizzo (vint *pV, int n)
{
  *pV += n;
}
