/* sort.c */

#include <stdio.h>
#include <stdlib.h>
#include "iocrema.h"


typedef int* vint;

// Aggiungere qui i prototipi delle tre funzioni necessarie
void LeggeVettoreInteri (vint *pV, int *pn);

void OrdinaVettoreInteri (vint V, int n);

void StampaVettoreInteri (vint V, int n);


int main (int argc, char *argv[])
{
  vint V;
  int n;

  // Aggiungere qui le chiamate alle tre funzioni necessarie per:
  // 1) leggere la lunghezza e gli elementi del vettore da ordinare
  LeggeVettoreInteri(&V,&n);

  // 2) ordinare il vettore per valori non decrescenti
  OrdinaVettoreInteri(V,n);


  // 3) stampare il vettore
  StampaVettoreInteri(V,n);

  //  Deallocare il vettore dinamico
  free(V);

	 return EXIT_SUCCESS;
}


// Aggiungere qui le definizioni delle tre funzioni necessarie


/* Chiede all'utente di indicare la lunghezza e gli elementi del vettore */
void LeggeVettoreInteri (vint *pV, int *pn)
{
  int i;

  StampaStringa("Quanti numeri interi si vogliono inserire? ");
  *pn = LeggeIntero();

  *pV = (vint) calloc(*pn+1,sizeof(int));

  // Legge i numeri da tastiera
  for (i = 1; i <= *pn; i++)
  {
    StampaStringa("V[");
    StampaIntero(i);
    StampaStringa("] = ");
    (*pV)[i] = LeggeIntero();
  }
  StampaStringa("\n\n");
}


int TrovaIndiceMassimo (vint V, int n)
{
  int i, iMax;

  iMax = 1;
  for (i = 2; i <= n; i++)
    if (V[i] > V[iMax]) iMax = i;

  return iMax;
}


void Scambia (int *pa, int *pb)
{
  int temp;

  temp = *pa;
  *pa = *pb;
  *pb = temp;
}


/* Ordina il vettore per valori non decrescenti */
void OrdinaVettoreInteri (vint V, int n)
{
  int i;

  while (n > 1)
  {
    i = TrovaIndiceMassimo(V,n);
    Scambia(&V[i],&V[n]);
    n--;
  }
}


/* Stampa il vettore */
void StampaVettoreInteri (vint V, int n)
{
  int i;

  for (i = 1; i <= n; i++)
  {
    StampaIntero(V[i]);
    StampaStringa(" ");
  }
  StampaStringa("\n");
}
