#ifndef __iocrema_h
#define __iocrema_h

/* Stampa la stringa di caratteri "s" */
void StampaStringa (char *s);

/* Legge la stringa di caratteri "s" */
void LeggeStringa (char *s);

/* Stampa il carattere "c" ripetuto "num" volte */
void StampaCarattere (char c, int num);

/* Va a capo */
void ACapo ();

/* Stampa il numero intero "n" */
void StampaIntero (int n);

/* Legge da tastiera un numero intero */
int LeggeIntero ();

/* Stampa il numero naturale "n" */
void StampaNaturale (unsigned int n);

/* Legge da tastiera un numero naturale */
unsigned int LeggeNaturale ();

/* Stampa il numero long "n" */
void StampaLong (long n);

/* Legge da tastiera un numero intero di tipo long */
long LeggeLong ();

/* Stampa il numero "f", reale di tipo float */
void StampaFloat (float f);

/* Legge da tastiera un numero reale di tipo float */
float LeggeFloat ();

/* Stampa il numero "d", reale di tipo double */
void StampaDouble (double d);

/* Legge da tastiera un numero reale di tipo double */
double LeggeDouble ();

/* Stampa l'indirizzo "i" */
void StampaIndirizzo (void *i);

/* Stampa la cifra in denaro rappresentata dal numero reale "f" */
void StampaCifraDenaro (float f);

/* Legge da tastiera una cifra in denaro e la converte in un numero reale di tipo float */
float LeggeCifraDenaro ();

/* Converte una stringa numerica in un numero intero (in caso di errore, termina il programma) */
int ConverteStringaInIntero (char *s);

#endif
