/* charges-sol.c */

#include <stdio.h>
#include <stdlib.h>
#include "iocrema.h"

#define FIX1    20.0
#define VAR1     0.0
#define FIX2    14.0
#define VAR2     0.6
#define FIX3    34.0
#define VAR3     0.4
#define FIX4   234.0
#define VAR4     0.2

#define MAX1   1000
#define MAX2  10000
#define MAX3 100000


float CalcolaCommissione (float ammontare);


int main (int argc, char *argv[])
{
  float ammontare, commissione;


  StampaStringa("Inserire la cifra da investire: ");
  ammontare = LeggeCifraDenaro();
  ACapo();

  commissione = CalcolaCommissione(ammontare);

  StampaStringa("La commissione e': ");
  StampaCifraDenaro(commissione);
  ACapo();

	 return EXIT_SUCCESS;
}


/* Calcola l'entita' della commissione */
float CalcolaCommissione (float ammontare)
{
  float commissione;

  if (ammontare <= MAX1)
    commissione = FIX1 + ammontare * VAR1 / 100.0;
  else if ((MAX1 < ammontare) && (ammontare <= MAX2))
    commissione = FIX2 + ammontare * VAR2 / 100.0;
  else if (ammontare <= MAX3)
    commissione = FIX3 + ammontare * VAR3 / 100.0;
  else
    commissione = FIX4 + ammontare * VAR4 / 100.0;

  return commissione;
}
