/* coppiequadrati.c

  Dati due file di testo, ciascuno dei quali contiene un elenco di numeri interi,
  si individuino i numeri della seconda lista che sono quadrati perfetti di numeri
  della prima lista. Si stampino le coppie di numeri nel formato:

  (n1,q1) (n2,q2)...

  cioe' con i numeri racchiusi fra parentesi tonde, senza spazi entro le parentesi
  e con un solo spazio fra le coppie, nello stesso ordine in cui compaiono nella lista.
  Se lo stesso numero compare piu' volte in una lista, si consideri come numeri
  diversi (variante piu' complessa: si stampi ogni numero non piu' di una volta).

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define EXIT_COMMANDLINE 1
#define EXIT_FILEACCESS  2
#define EXIT_MEMORY      3

#define NAME_LENGTH 255

typedef enum {FALSE,TRUE} boolean;
typedef int* vint;


void InterpretaLineaComando (int argc, char *argv[], char *NomeFile1, char *NomeFile2);

void CaricaVettoreInteri (char *NomeFile, vint *pV, long *pNum);

void StampaCoppieQuadrati (vint V1, long Num1, vint V2, long Num2);


int main (int argc, char *argv[])
{
  char NomeFile1[NAME_LENGTH+1];
  char NomeFile2[NAME_LENGTH+1];
  vint V1, V2;
  long Num1, Num2;


  /* Interpreta la linea di comando per caricare il nome dei due file */
  InterpretaLineaComando(argc,argv,NomeFile1,NomeFile2);

  /* Carica la prima lista di numeri interi */
  CaricaVettoreInteri(NomeFile1,&V1,&Num1);

  /* Carica la seconda lista di numeri interi */
  CaricaVettoreInteri(NomeFile2,&V2,&Num2);

  /* Stampa le coppie di quadrati */
  StampaCoppieQuadrati(V1,Num1,V2,Num2);

	 return EXIT_SUCCESS;
}


void StampaIstruzioni (char *comando)
{
  fprintf(stderr,"%s nomefile1 nomefile2\n",comando);
  fprintf(stderr,"nomefile1: file contenente la prima   lista di interi\n");
  fprintf(stderr,"nomefile2: file contenente la seconda lista di interi\n");
}


/* Interpreta la linea di comando per caricare il nome del file */
void InterpretaLineaComando (int argc, char *argv[], char *NomeFile1, char *NomeFile2)
{
  if (argc != 3)
  {
    fprintf(stderr,"Linea di comando errata!\n");
    StampaIstruzioni(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  strcpy(NomeFile1,argv[1]);
  strcpy(NomeFile2,argv[2]);
}




void CaricaVettoreInteri (char *NomeFile, vint *pV, long *pNum)
{
  FILE *fp;
  int i;


  fp = fopen(NomeFile,"r");
  if (fp == NULL)
  {
    fprintf(stderr,"Errore nell'apertura del file %s!\n",NomeFile);
    exit(EXIT_FILEACCESS);
  }

  *pNum = 0;
  while (fscanf(fp,"%d",&i) == 1)
    (*pNum)++;

  *pV = (vint) calloc(*pNum+1,sizeof(int));
  if (fp == NULL)
  {
    fprintf(stderr,"Memoria insufficiente per allocare V!\n");
    exit(EXIT_MEMORY);
  }

  rewind(fp);

  *pNum = 0;
  while (fscanf(fp,"%d",&i) == 1)
  {
    (*pNum)++;
    (*pV)[*pNum] = i;
  }

  fclose(fp);
}


void StampaCoppieQuadrati (vint V1, long Num1, vint V2, long Num2)
{
  int i1, i2;

  for (i1 = 1; i1 <= Num1; i1++)
    for (i2 = 1; i2 <= Num2; i2++)
      if (V2[i2] == V1[i1]*V1[i1])
        printf("(%d,%d) ",V1[i1],V2[i2]);
}
