/* tsp.c

  Dato un file di testo contenente un numero intero n seguito da n righe,
  ciascuna contenente due numeri interi che rappresentano le coordinate di punti,
  si parta dal primo punto e si raggiunge il punto piu' vicino ad esso.
  Poi si raggiunga il punto piu' vicino ancora non toccato, ecc... fino a che
  tutti i punti sono stati toccati. Allora, si ritorni al primo punto.
  Si restituisca la distanza totale percorsa, arrotondata a 3 cifre decimali.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define EXIT_COMMANDLINE 1
#define EXIT_FILEACCESS  2
#define EXIT_MEMORY      3

#define NAME_LENGTH 255

typedef enum {FALSE,TRUE} boolean;
typedef int* vint;


void InterpretaLineaComando (int argc, char *argv[], char *NomeFile);

void CaricaPunti (char *NomeFile, vint *px, vint *py, long *pNum);

double CalcolaPercorso (vint x, vint y, long Num);


int main (int argc, char *argv[])
{
  char NomeFile[NAME_LENGTH+1];
  double Dist;
  vint x, y;
  long Num;


  /* Interpreta la linea di comando per caricare il nome del file */
  InterpretaLineaComando(argc,argv,NomeFile);

  /* Carica i punti */
  CaricaPunti(NomeFile,&x,&y,&Num);

  /* Calcola il percorso */
  Dist = CalcolaPercorso(x,y,Num);

  /* Stampa il risultato */
  printf("Distanza percorsa: %.3lf\n",Dist);

  /* Dealloca le strutture dati ausiliarie */
  free(x);
  free(y);

  return EXIT_SUCCESS;
}


void StampaIstruzioni (char *comando)
{
  fprintf(stderr,"%s nomefile\n",comando);
  fprintf(stderr,"nomefile: file contenente le coordinate\n");
}


/* Interpreta la linea di comando per caricare il nome del file */
void InterpretaLineaComando (int argc, char *argv[], char *NomeFile)
{
  if (argc != 2)
  {
    fprintf(stderr,"Linea di comando errata!\n");
    StampaIstruzioni(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  strcpy(NomeFile,argv[1]);
}


double Distanza (int x1, int y1, int x2, int y2)
{
  return sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
}


void CaricaPunti (char *NomeFile, vint *px, vint *py, long *pNum)
{
}


double CalcolaPercorso (vint x, vint y, long Num)
{
}







