/* tsp.c

  Dato un file di testo contenente un numero intero n seguito da n righe,
  ciascuna contenente due numeri interi che rappresentano le coordinate di punti,
  si parta dal primo punto e si raggiunge il punto piu' vicino ad esso.
  Poi si raggiunga il punto piu' vicino ancora non toccato, ecc... fino a che
  tutti i punti sono stati toccati. Allora, si ritorni al primo punto.
  Si restituisca la distanza totale percorsa, arrotondata a 3 cifre decimali.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define EXIT_COMMANDLINE 1
#define EXIT_FILEACCESS  2
#define EXIT_MEMORY      3

#define NAME_LENGTH 255

typedef enum {FALSE,TRUE} boolean;
typedef int* vint;


void InterpretaLineaComando (int argc, char *argv[], char *NomeFile);

void CaricaPunti (char *NomeFile, vint *px, vint *py, long *pNum);

double CalcolaPercorso (vint x, vint y, long Num);

double CalcolaPercorso (vint x, vint y, long Num);


int main (int argc, char *argv[])
{
  char NomeFile[NAME_LENGTH+1];
  double Dist;
  vint x, y;
  long Num;


  /* Interpreta la linea di comando per caricare il nome del file */
  InterpretaLineaComando(argc,argv,NomeFile);

  /* Carica i punti */
  CaricaPunti(NomeFile,&x,&y,&Num);

  /* Calcola il percorso */
  Dist = CalcolaPercorso(x,y,Num);

  /* Stampa il risultato */
  printf("Distanza percorsa: %.3lf\n",Dist);

  /* Dealloca le strutture dati ausiliarie */
  free(x);
  free(y);

	 return EXIT_SUCCESS;
}


void StampaIstruzioni (char *comando)
{
  fprintf(stderr,"%s nomefile\n",comando);
  fprintf(stderr,"nomefile: file contenente le coordinate\n");
}


/* Interpreta la linea di comando per caricare il nome del file */
void InterpretaLineaComando (int argc, char *argv[], char *NomeFile)
{
  if (argc != 2)
  {
    fprintf(stderr,"Linea di comando errata!\n");
    StampaIstruzioni(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  strcpy(NomeFile,argv[1]);
}


double Distanza (int x1, int y1, int x2, int y2)
{
  return sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
}


void CaricaPunti (char *NomeFile, vint *px, vint *py, long *pNum)
{
  FILE *fp;
  int i, x, y;


  fp = fopen(NomeFile,"r");
  if (fp == NULL)
  {
    fprintf(stderr,"Errore nell'apertura del file %s!\n",NomeFile);
    exit(EXIT_FILEACCESS);
  }

  fscanf(fp,"%d",pNum);

  *px = (vint) calloc(*pNum+1,sizeof(int));
  if (*px == NULL)
  {
    fprintf(stderr,"Memoria insufficiente per allocare *px!\n");
    exit(EXIT_MEMORY);
  }

  *py = (vint) calloc(*pNum+1,sizeof(int));
  if (*py == NULL)
  {
    fprintf(stderr,"Memoria insufficiente per allocare *pyfs!\n");
    exit(EXIT_MEMORY);
  }

  for (i = 1; i <= *pNum; i++)
  {
    fscanf(fp,"%d %d",&x,&y);
    (*px)[i] = x;
    (*py)[i] = y;
  }

  fclose(fp);
}


double CalcolaPercorso (vint x, vint y, long Num)
{
  int p, pp, pMin;
  double dist, distMin, distTot;
  long cont;
  boolean *Visited;


  Visited = (boolean *) calloc(Num+1,sizeof(boolean));
  if (Visited == NULL)
  {
    fprintf(stderr,"Memoria insufficiente per allocare Visited!\n");
    exit(EXIT_MEMORY);
  }

  p = 1;
  Visited[1] = TRUE;
  cont = 1;
  distTot = 0.0;
  while (cont < Num)
  {
    // Trova il punto non visitato piu' vicino a p
    pMin = 0;
    distMin = DBL_MAX;
    for (pp = 1; pp <= Num; pp++)
      if (Visited[pp] == FALSE)
      {
        dist = Distanza(x[p],y[p],x[pp],y[pp]);
        if (dist < distMin)
        {
          pMin = pp;
          distMin = dist;
        }
      }

    cont++;
    p = pMin;
    Visited[pMin] = TRUE;
    distTot += distMin;
  }

  distTot += Distanza(x[p],y[p],x[1],y[1]);

  free(Visited);

  return distTot;
}
