/* query3.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define EXIT_COMMANDLINE 1
#define EXIT_FILEACCESS  2
#define EXIT_MEMORY      3
#define EXIT_FILEFORMAT  4

#define LUNGHEZZA 255


void InterpretaParametri (int argc, char *argv[], char *FileDati);

void StampaAiuto (char *nome);


int main (int argc, char *argv[])
{
  char FileDati[LUNGHEZZA+1];
  char s[LUNGHEZZA+1];
  FILE *fFileDati1, *fFileDati2;
  int i, d;
  double p;


  /* Interpreta la linea di comando e determina il numero di file da creare */
  InterpretaParametri(argc,argv,FileDati);

  /* Apre il file dei dati per cercare le disponibilita' */
  fFileDati1 = fopen(FileDati,"r");
  if (fFileDati1 == NULL)
  {
    fprintf(stderr,"Impossibile leggere il file %s!\n",FileDati);
    exit(EXIT_FILEACCESS);
  }

  /* Cerca la parola chiave "Disponibilita:" */
  while (fscanf(fFileDati1,"%s",s) == 1)
    if (strcmp(s,"Disponibilita:") == 0) break;

  /* Apre un'altra volta il file dei dati, per leggere in parallelo i prezzi */
  fFileDati2 = fopen(FileDati,"r");
  if (fFileDati2 == NULL)
  {
    fprintf(stderr,"Impossibile leggere il file %s!\n",FileDati);
    exit(EXIT_FILEACCESS);
  }

  /* Cerca la parola chiave "Prezzi:" con il secondo puntatore */
  while (fscanf(fFileDati2,"%s",s) == 1)
    if (strcmp(s,"Prezzi:") == 0) break;

  /* Scorre le disponibilita' e in parallelo i prezzi
     e per gli articoli disponibili stampa indice e prezzo */
  printf("Articoli disponibili in %s:\n",FileDati);
  i = 0;
  while (fscanf(fFileDati1,"%d",&d) == 1)
  {
    fscanf(fFileDati2,"%lf",&p);
    i++;
    if (d > 0) printf("%4d %6.2lf euro\n",i,p);
  }

  /* Chiude il file dei dati due volte */
  fclose(fFileDati1);
  fclose(fFileDati2);

	 return EXIT_SUCCESS;
}


/* Interpreta la linea i comando e determina il numero su cui operare */
void InterpretaParametri (int argc, char *argv[], char *FileDati)
{
  if (argc != 2)
  {
    printf("Numero di parametri errato!\n");
    StampaAiuto(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  strcpy(FileDati,argv[1]);
}


/* Stampa un messaggio che spiega l'uso del programma */
void StampaAiuto (char *nome)
{
  fprintf(stderr,"Il formato corretto e':\n");
  fprintf(stderr,"%s nomefile\n",nome);
  fprintf(stderr,"nomefile: nome del file contenente i dati\n");
}
