/* query1.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define EXIT_COMMANDLINE 1
#define EXIT_FILEACCESS  2
#define EXIT_MEMORY      3
#define EXIT_FILEFORMAT  4

#define LUNGHEZZA 255


enum _boolean {FALSE = 0, TRUE = 1};
typedef enum _boolean boolean;


void InterpretaParametri (int argc, char *argv[], char *FileDati);

void StampaAiuto (char *nome);


int main (int argc, char *argv[])
{
  char FileDati[LUNGHEZZA+1];
  char s[LUNGHEZZA+1];
  FILE *fFileDati;
  int cont, i, d;
  double p;
  boolean *Disp;


  /* Interpreta la linea di comando */
  InterpretaParametri(argc,argv,FileDati);

  /* Apre il file dei dati */
  fFileDati = fopen(FileDati,"r");
  if (fFileDati == NULL)
  {
    fprintf(stderr,"Impossibile leggere il file %s!\n",FileDati);
    exit(EXIT_FILEACCESS);
  }

  /* Cerca la parola chiave "Disponibilita:" */
  while (fscanf(fFileDati,"%s",s) == 1)
    if (strcmp(s,"Disponibilita:") == 0) break;

  /* Conta le disponibilit, e quindi gli articoli */
  cont = 0;
  while (fscanf(fFileDati,"%d",&d) == 1)
    cont++;


  /* Alloca il vettore delle disponibilit */
  Disp = (boolean *) calloc(cont+1,sizeof(boolean));
  if (Disp == NULL)
  {
    fprintf(stderr,"Memoria insufficiente per allocare il vettore Disp!\n");
    exit(EXIT_MEMORY);
  }


  /* Torna al principio del file dei dati */
  rewind(fFileDati);


  /* Cerca la parola chiave "Disponibilita:" */
  while (fscanf(fFileDati,"%s",s) == 1)
    if (strcmp(s,"Disponibilita:") == 0) break;

  /* Legge le disponibilita (supponiamo siano tante quanti i prezzi) */
  for (i = 1; i <= cont; i++)
  {
    fscanf(fFileDati,"%d",&d);
    Disp[i] = ( (d == 0) ? FALSE : TRUE );
  }

  /* Torna al principio del file dei dati */
  rewind(fFileDati);

  /* Cerca la parola chiave "Prezzi:" */
  while (fscanf(fFileDati,"%s",s) == 1)
    if (strcmp(s,"Prezzi:") == 0) break;

  /* Stampa indici e prezzi degli articoli disponibili */
  printf("Articoli disponibili in %s:\n",FileDati);
  for (i = 1; i <= cont; i++)
  {
    fscanf(fFileDati,"%lf",&p);
    if (Disp[i] == TRUE) printf("%4d %6.2lf euro\n",i,p);
  }

  /* Chiude il file dei dati */
  fclose(fFileDati);

  free(Disp);

  return EXIT_SUCCESS;
}


/* Interpreta la linea i comando e determina il numero su cui operare */
void InterpretaParametri (int argc, char *argv[], char *FileDati)
{
  if (argc != 2)
  {
    fprintf(stderr,"Numero di parametri errato!\n");
    StampaAiuto(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  strcpy(FileDati,argv[1]);
}


/* Stampa un messaggio che spiega l'uso del programma */
void StampaAiuto (char *nome)
{
  fprintf(stderr,"Il formato corretto e':\n");
  fprintf(stderr,"%s nomefile\n",nome);
  fprintf(stderr,"nomefile: nome del file contenente i dati\n");
}
