/* coppiequadrati.c

  Dati due file di testo, ciascuno dei quali contiene un elenco di numeri interi,
  si individuino i numeri della seconda lista che sono quadrati perfetti di numeri
  della prima lista. Si stampino le coppie di numeri nel formato:

  (n1,q1) (n2,q2)...

  cioe' con i numeri racchiusi fra parentesi tonde, senza spazi entro le parentesi
  e con un solo spazio fra le coppie, nello stesso ordine in cui compaiono nella lista.
  Se lo stesso numero compare piu' volte in una lista, si consideri come numeri
  diversi (variante piu' complessa: si stampi ogni numero non piu' di una volta).

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define EXIT_COMMANDLINE 1
#define EXIT_FILEACCESS  2
#define EXIT_MEMORY      3

#define NAME_LENGTH 255

typedef enum {FALSE,TRUE} boolean;
typedef int* vint;


void InterpretaLineaComando (int argc, char *argv[], char *NomeFile1, char *NomeFile2);

void CaricaVettoreInteri (char *NomeFile, vint *pV, long *pNum);

void StampaCoppieQuadrati (vint V1, long Num1, vint V2, long Num2);


int main (int argc, char *argv[])
{
  char NomeFile1[NAME_LENGTH+1];
  char NomeFile2[NAME_LENGTH+1];
  vint V1, V2;
  long Num1, Num2;


  /* Interpreta la linea di comando per caricare il nome dei due file */
  InterpretaLineaComando(argc,argv,NomeFile1,NomeFile2);

  /* Carica la prima lista di numeri interi */
  CaricaVettoreInteri(NomeFile1,&V1,&Num1);

  /* Carica la seconda lista di numeri interi */
  CaricaVettoreInteri(NomeFile2,&V2,&Num2);

  /* Stampa le coppie di quadrati */
  StampaCoppieQuadrati(V1,Num1,V2,Num2);

	 return EXIT_SUCCESS;
}


void StampaIstruzioni (char *comando)
{
  fprintf(stderr,"%s nomefile1 nomefile2\n",comando);
  fprintf(stderr,"nomefile1: file contenente la prima   lista di interi\n");
  fprintf(stderr,"nomefile2: file contenente la seconda lista di interi\n");
}


/* Interpreta la linea di comando per caricare il nome del file */
void InterpretaLineaComando (int argc, char *argv[], char *NomeFile1, char *NomeFile2)
{
  if (argc != 3)
  {
    fprintf(stderr,"Linea di comando errata!\n");
    StampaIstruzioni(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  strcpy(NomeFile1,argv[1]);
  strcpy(NomeFile2,argv[2]);
}




void CaricaVettoreInteri (char *NomeFile, vint *pV, long *pNum)
{
}


void StampaCoppieQuadrati (vint V1, long Num1, vint V2, long Num2)
{
}
