/* quadrati0.c

   Conta i quadrati perfetti compresi fra i due numeri naturali a e b
   trasmessi con la linea di comando

*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>


#define EXIT_COMMANDLINE 1

typedef enum {FALSE,TRUE} boolean;


void InterpretaLineaComando (int argc, char *argv[], long *pa, long *pb);

long ContaQuadrati (long a, long b);


int main (int argc, char *argv[])
{
  long a, b;
  long cont;
  time_t inizio, fine;
  double durata;


  /* Interpreta la linea di comando per caricare i due numeri */
  InterpretaLineaComando(argc,argv,&a,&b);

  /* Calcola il numero dei quadrati perfetti */
  inizio = clock();
  cont = ContaQuadrati(a,b);
  fine = clock();
  durata = (fine - inizio)/CLOCKS_PER_SEC;

  /* Stampa il numero dei quadrati perfetti */
  printf("Quadrati perfetti in [%ld,%ld]: %ld\n",a,b,cont);
  printf("Tempo: %.3lf secondi\n",durata);

	 return EXIT_SUCCESS;
}


void StampaIstruzioni (char *comando)
{
  fprintf(stderr,"%s a b\n",comando);
  fprintf(stderr,"a: primo   termine (intero positivo)\n");
  fprintf(stderr,"b: secondo termine (intero positivo)\n");
}


/* Interpreta la linea di comando per caricare i due numeri */
void InterpretaLineaComando (int argc, char *argv[], long *pa, long *pb)
{
  if (argc != 3)
  {
    fprintf(stderr,"Linea di comando errata!\n");
    StampaIstruzioni(argv[0]);
    exit(EXIT_COMMANDLINE);
  }
  else if ( (sscanf(argv[1],"%ld",pa) != 1) || (sscanf(argv[2],"%ld",pb) != 1) )
  {
    fprintf(stderr,"Linea di comando errata!\n");
    StampaIstruzioni(argv[0]);
    exit(EXIT_COMMANDLINE);
  }
  else if ( (*pa <= 0) || (*pb <= 0) )
  {
    fprintf(stderr,"Linea di comando errata!\n");
    StampaIstruzioni(argv[0]);
    exit(EXIT_COMMANDLINE);
  }
}


long ContaQuadrati (long a, long b)
{
  return 0L;
}
