/* parolafrequente.c

  Dato un file di testo, si stampi la parola che vi compare piu' spesso e il
  numero delle sue occorrenze. Si facciano ipotesi ragionevoli sul numero e
  la lunghezza delle parole per dimensionare le strutture dati.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define EXIT_COMMANDLINE 1
#define EXIT_FILEACCESS  2
#define EXIT_MEMORY      3

#define NAME_LENGTH 255

typedef enum {FALSE,TRUE} boolean;
typedef char Parola[NAME_LENGTH+1];


void InterpretaLineaComando (int argc, char *argv[], char *NomeFile);

void TrovaParolaFrequente (char *NomeFile, Parola s, long *pf);


int main (int argc, char *argv[])
{
  char NomeFile[NAME_LENGTH+1];
  Parola s;
  long cont;


  /* Interpreta la linea di comando per caricare la stringa e il nome del file */
  InterpretaLineaComando(argc,argv,NomeFile);

  /* Calcola il numero di occorrenze di s nel file NomeFile */
  TrovaParolaFrequente(NomeFile,s,&cont);

  /* Stampa il risultato */
  printf("Parola piu' frequente: %s (%ld occorrenze)\n",s,cont);

	 return EXIT_SUCCESS;
}


void StampaIstruzioni (char *comando)
{
  fprintf(stderr,"%s nomefile\n",comando);
  fprintf(stderr,"nomefile: nome del file da elaborare\n");
}


/* Interpreta la linea di comando per caricare il nome del file */
void InterpretaLineaComando (int argc, char *argv[], char *NomeFile)
{
  if (argc != 2)
  {
    fprintf(stderr,"Linea di comando errata!\n");
    StampaIstruzioni(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  strcpy(NomeFile,argv[1]);
}


/* Determina la parola piu' frequente nel file NomeFile e il suo numero di occorrenze */

void TrovaParolaFrequente (char *NomeFile, Parola s, long *pf)
{
}
