/* parolafrequente.c

  Dato un file di testo, si stampi la parola che vi compare piu' spesso e il
  numero delle sue occorrenze. Si facciano ipotesi ragionevoli sul numero e
  la lunghezza delle parole per dimensionare le strutture dati.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define EXIT_COMMANDLINE 1
#define EXIT_FILEACCESS  2
#define EXIT_MEMORY      3

#define NAME_LENGTH 255

typedef enum {FALSE,TRUE} boolean;
typedef char Parola[NAME_LENGTH+1];


void InterpretaLineaComando (int argc, char *argv[], char *NomeFile);

void TrovaParolaFrequente (char *NomeFile, Parola s, long *pf);


int main (int argc, char *argv[])
{
  char NomeFile[NAME_LENGTH+1];
  Parola s;
  long cont;


  /* Interpreta la linea di comando per caricare la stringa e il nome del file */
  InterpretaLineaComando(argc,argv,NomeFile);

  /* Calcola il numero di occorrenze di s nel file NomeFile */
  TrovaParolaFrequente(NomeFile,s,&cont);

  /* Stampa il risultato */
  printf("Parola piu' frequente: %s (%ld occorrenze)\n",s,cont);

	 return EXIT_SUCCESS;
}


void StampaIstruzioni (char *comando)
{
  fprintf(stderr,"%s nomefile\n",comando);
  fprintf(stderr,"nomefile: nome del file da elaborare\n");
}


/* Interpreta la linea di comando per caricare il nome del file */
void InterpretaLineaComando (int argc, char *argv[], char *NomeFile)
{
  if (argc != 2)
  {
    fprintf(stderr,"Linea di comando errata!\n");
    StampaIstruzioni(argv[0]);
    exit(EXIT_COMMANDLINE);
  }

  strcpy(NomeFile,argv[1]);
}


/* Determina la parola piu' frequente nel file NomeFile e il suo numero di occorrenze */

void TrovaParolaFrequente (char *NomeFile, Parola s, long *pf)
{
  Parola *V;
  long *Frequenza;
  long NumParole;
  FILE *fNomeFile;
  Parola temp;
  long p, fMax, pMax;


  fNomeFile = fopen(NomeFile,"r");
  if (fNomeFile == NULL)
  {
    fprintf(stderr,"Apertura del file %s fallita!\n",NomeFile);
    exit(EXIT_FILEACCESS);
  }

  // Conta le parole, per dimensionare i vettori V e Frequenze
  NumParole = 0;
  while (fscanf(fNomeFile,"%s",temp) == 1)
    NumParole++;

  V = (Parola *) calloc(NumParole+1,sizeof(Parola));
  if (V == NULL)
  {
    fprintf(stderr,"Memoria insufficiente per allocare V!\n");
    exit(EXIT_MEMORY);
  }

  Frequenza = (long *) calloc(NumParole+1,sizeof(long));
  if (Frequenza == NULL)
  {
    fprintf(stderr,"Memoria insufficiente per allocare Frequenza!\n");
    exit(EXIT_MEMORY);
  }

  rewind(fNomeFile);

  NumParole = 0;
  while (fscanf(fNomeFile,"%s",temp) == 1)
  {
    for (p = 1; p <= NumParole; p++)
      if (strcmp(temp,V[p]) == 0) break;

    if (p > NumParole)
    {
      NumParole++;
      strcpy(V[NumParole],temp);
    }

    Frequenza[p]++;
  }

  fclose(fNomeFile);

  fMax = pMax = 0;
  for (p = 1; p <= NumParole; p++)
    if (Frequenza[p] > fMax)
    {
      fMax = Frequenza[p];
      pMax = p;
    }

  strcpy(s,V[pMax]);
  *pf = fMax;

  free(V);
  free(Frequenza);
}
