/* mcd.c

   Calcola il massimo comun divisore di due numeri interi a e b
   trasmessi con la linea di comando

   Lo fa fattorizzando i due numeri e moltiplicando i soli fattori comuni.

*/

#include <stdio.h>
#include <stdlib.h>

#include <time.h>


#define EXIT_COMMANDLINE 1
#define EXIT_MEMORY      2

typedef enum {FALSE,TRUE} boolean;


void InterpretaLineaComando (int argc, char *argv[], long *pa, long *pb);

void StampaIstruzioni (char *comando);

void Fattorizza (long a, int *V);

long MassimoComunDivisore (long a, long b);


int main (int argc, char *argv[])
{
  long a, b;
  int MCD;
  time_t inizio, fine;
  double durata;


  /* Interpreta la linea di comando per caricare i due numeri */
  InterpretaLineaComando(argc,argv,&a,&b);

  /* Calcola il MCD */
  inizio = clock();
  MCD = MassimoComunDivisore(a,b);
  fine = clock();
  durata = (fine - inizio)/CLOCKS_PER_SEC;

  /* Stampa il MCD */
  printf("MCD: %ld\n",MCD);
  printf("Tempo: %.3lf secondi\n",durata);

  return EXIT_SUCCESS;
}


/* Interpreta la linea di comando per caricare i due numeri */
void InterpretaLineaComando (int argc, char *argv[], long *pa, long *pb)
{
  if (argc != 3)
  {
    fprintf(stderr,"Linea di comando errata!\n");
    StampaIstruzioni(argv[0]);
    exit(EXIT_COMMANDLINE);
  }
  else if ( (sscanf(argv[1],"%ld",pa) != 1) || (sscanf(argv[2],"%ld",pb) != 1) )
  {
    fprintf(stderr,"Linea di comando errata!\n");
    StampaIstruzioni(argv[0]);
    exit(EXIT_COMMANDLINE);
  }
  else if ( (*pa < 0) || (*pb < 0) )
  {
    fprintf(stderr,"Linea di comando errata!\n");
    StampaIstruzioni(argv[0]);
    exit(EXIT_COMMANDLINE);
  }
}


void StampaIstruzioni (char *comando)
{
  fprintf(stderr,"%s a b\n",comando);
  fprintf(stderr,"a: primo   termine (intero positivo)\n");
  fprintf(stderr,"b: secondo termine (intero positivo)\n");
}


long MassimoComunDivisore (long a, long b)
{
  int *Va, *Vb, *V;
  long MCD, min, i, e;

  Va = (int *) calloc(a+1,sizeof(int));
  if (Va == NULL)
  {
    fprintf(stderr,"Memoria insufficiente per allocare Va!\n");
    exit(EXIT_MEMORY);
  }

  Fattorizza(a,Va);
/*
  for (i = 2; i <= a; i++)
    if (Va[i] > 0)
     printf("%ld: %d\n",i,Va[i]);
*/
  Vb = (int *) calloc(b+1,sizeof(int));
  if (Vb == NULL)
  {
    fprintf(stderr,"Memoria insufficiente per allocare Vb!\n");
    exit(EXIT_MEMORY);
  }

  Fattorizza(b,Vb);
/*
  for (i = 2; i <= b; i++)
    if (Vb[i] > 0)
     printf("%ld: %d\n",i,Vb[i]);
*/
  min = ( (a < b) ? a : b );
  MCD = 1;
  for (i = 2; i <= min; i++)
    for (e = 1; (e <= Va[i]) && (e <= Vb[i]); e++)
      MCD *= i;

  free(Va);
  free(Vb);

  return MCD;
}


void Fattorizza (long a, int *V)
{
  long i;

  i = 2;
  while (i <= a)
  {
    if (a % i != 0)
      i++;
    else
    {
      V[i]++;
      a /= i;
    }
  }
}
