/* griglia0.c

   Partendo dalla posizione (0,0), esegue una serie di spostamenti
   contenuti in un file di testo indicato nella linea di comando.
   Stampa la posizione raggiunta al termine degli spostamenti.

*/

#include <stdio.h>
#include <stdlib.h>


#define LUNGHEZZA 255

#define EXIT_COMMANDLINE 1
#define EXIT_FILEACCESS  2

typedef enum {FALSE,TRUE} boolean;


void InterpretaLineaComando (int argc, char *argv[], char *NomeDati);

void EsegueSpostamenti (char *NomeDati, long *pt, long *pxf, long *pyf);


int main (int argc, char *argv[])
{
  char NomeDati[LUNGHEZZA+1];
  long t, xf, yf;


  /* Interpreta la linea di comando per caricare i due numeri */
  InterpretaLineaComando(argc,argv,NomeDati);

  /* Definisce e stampa l'istante e la posizione iniziale */
  t = xf = yf = 0;
  printf("t = %6d: posizione (%d,%d)\n",0,xf,yf);

  /* Esegue gli spostamenti indicati nel file NomeDati a partire
     dalla posizione (0,0) e restituisce la posizione finale (xf,yf) */
  EsegueSpostamenti(NomeDati,&t,&xf,&yf);

  /* Stampa la posizione finale */
  printf("t = %6d: posizione (%d,%d)\n",t,xf,yf);

  return EXIT_SUCCESS;
}


void StampaIstruzioni (char *comando)
{
  fprintf(stderr,"%s filedati\n",comando);
  fprintf(stderr,"filedati: nome del file contenente gli spostamenti\n");
}


/* Interpreta la linea di comando per caricare i due numeri */
void InterpretaLineaComando (int argc, char *argv[], char *NomeDati)
{
  if (argc != 2)
  {
    fprintf(stderr,"Linea di comando errata!\n");
    StampaIstruzioni(argv[0]);
    exit(EXIT_COMMANDLINE);
  }
  strcpy(NomeDati,argv[1]);
}


void EsegueSpostamenti (char *NomeDati, long *pt, long *pxf, long *pyf)
{
}














