/* segreteria.c (Prof.Cordone) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "iocrema.h"

#define LUNGHEZZA         256
#define MAX_STUDENTI      1
#define MATRICOLA_BASE 600000

typedef struct {
  long id;
  char nome[LUNGHEZZA+1];
  char cognome[LUNGHEZZA+1];
} persona;

typedef struct {
  long matricola;
  persona identita;
} studente;


// Aggiunge uno studente con un dato "nome" e "cognome" a una "classe" con un dato numero di studenti.
// Lo studente va aggiunto  nella prima posizione vuota (NumStudenti+1).
// Il numero di matricola va automaticamente attribuito ed  immediatamente successivo a quella
// dell'ultimo studente inserito. Se la classe  vuota, il primo studente ha matricola MATRICOLA_BASE

void AggiungeStudente (char *nome, char *cognome, studente *classe, int NumStudenti);

void StampaPersona (persona p);

void StampaStudente (studente s);

int CercaStudentePerMatricola(long m, studente *classe, int NumStudenti);

int CercaStudentePerNome(char *n,char *c, studente *classe,int NumStudenti);

void ToglieStudente(int pos, studente *classe, int *NumStudenti);

// Stampa l'elenco degli studenti, uno per riga, utilizzando (approccio top-down)
// una funzione StampaStudente che riceve un dato di tipo "studente" e stampa
// nome e cognome (chiamando una funzione StampaPersona, che riceve un dato di tipo "persona")
// e la matricola fra parentesi tonde.
void StampaClasse (studente *classe, int NumStudenti);


int main (int argc, char *argv[])
{
  char nome[LUNGHEZZA+1], cognome[LUNGHEZZA+1];
  studente classe[MAX_STUDENTI+1];
  int NumStudenti;


  // Chiede all'utente di inserire un nuovo studente alla volta, fornendo nome e cognome
  NumStudenti = 0;
  do
  {
    StampaStringa("Inserire i dati di un nuovo studente (EXIT se si vuole terminare):\n");
    StampaStringa("Nome: ");
    LeggeStringa(nome);
    if (strcmp(nome,"EXIT") != 0)
    {
      StampaStringa("Cognome: ");
      LeggeStringa(cognome);
      AggiungeStudente(nome,cognome,classe,NumStudenti);
      NumStudenti++;
    }
  } while (strcmp(nome,"EXIT") != 0);
  ToglieStudente(1,classe,&NumStudenti);
  StampaClasse(classe,NumStudenti);

  int ricerca = -2;

  ricerca = CercaStudentePerMatricola(MATRICOLA_BASE+1, classe,NumStudenti);
  if(ricerca > 0){
	StampaStringa("Lo studente e' alla posizione: ");
	StampaIntero(ricerca);
  }
  else{
	StampaStringa("Errore, studente non trovato");
  }
  ACapo();
  
  
  ricerca = -2;

  ricerca = CercaStudentePerNome("Mario","Rossi", classe,NumStudenti);
  if(ricerca > 0){
	StampaStringa("Lo studente Mario Rossi e' alla posizione: ");
	StampaIntero(ricerca);
  }
  else{
	StampaStringa("Errore, studente Mario Rossi non trovato");
  }
  ACapo();
  

  
  
  return EXIT_SUCCESS;
}


// Aggiunge uno studente con un dato "nome" e "cognome" a una "classe" con un dato numero di studenti.
// Lo studente va aggiunto  nella prima posizione vuota (NumStudenti+1).
// Il numero di matricola va automaticamente attribuito ed  immediatamente successivo a quella
// dell'ultimo studente inserito. Se la classe  vuota, il primo studente ha matricola MATRICOLA_BASE

void AggiungeStudente (char *nome, char *cognome, studente *classe, int NumStudenti)
{
  if (NumStudenti+1 > MAX_STUDENTI)
    printf("Errore: la classe e' piena!\n");
  else
  {
    if (NumStudenti == 0)
      classe[NumStudenti+1].matricola = MATRICOLA_BASE;
    else
      classe[NumStudenti+1].matricola = classe[NumStudenti].matricola + 1;

    strcpy(classe[NumStudenti+1].identita.nome,nome);
    strcpy(classe[NumStudenti+1].identita.cognome,cognome);
  }
}


// Stampa l'elenco degli studenti, uno per riga, utilizzando (approccio top-down)
// una funzione StampaStudente che riceve un dato di tipo "studente" e stampa
// nome e cognome (chiamando una funzione StampaPersona, che riceve un dato di tipo "persona")
// e la matricola fra parentesi tonde.

void StampaClasse (studente *classe, int NumStudenti)
{
  int i;

  for (i = 1; i <= NumStudenti; i++)
  {
    StampaStudente(classe[i]);
    StampaStringa("\n");
  }
}


void StampaPersona (persona p)
{
  StampaStringa(p.nome);
  StampaStringa(" ");
  StampaStringa(p.cognome);
}


void StampaStudente (studente s)
{
  StampaPersona(s.identita);
  StampaStringa(" (");
  StampaLong(s.matricola);
  StampaStringa(")");
}


int CercaStudentePerMatricola(long m, studente *classe,int NumStudenti){
	int i = 1;
	short trovato = 0;
	
	while(i <= NumStudenti-1 && !trovato )
  {
	if(classe[i].matricola == m){
		trovato=1;
		return i;
	}
	i++;
  }
  return -1;
	
}

int CercaStudentePerNome(char *n,char *c, studente *classe,int NumStudenti){
	int i = 1;
	short trovato = 0;
	
	while(i <= NumStudenti-1 && !trovato )
  {
	if(strcmp(classe[i].identita.nome,n)==0 && strcmp(classe[i].identita.cognome,c)==0 ){
		trovato=1;
		return i;
	}
	i++;
  }
  return -1;
	
}

void ToglieStudente(int pos, studente *classe, int *NumStudenti){
	
	
	while(pos < *NumStudenti){
		classe[pos]=classe[pos+1];
		pos++;
	}
	*NumStudenti--;

}





