/* insertionsort.c */

#include <stdio.h>
#include <stdlib.h>
#include "iocrema.h"


typedef int* vint;

void LeggeVettoreInteri (vint *pV, int *pn);

void StampaVettoreInteri (vint V, int n);

void InsertionSort (int *V, int n);


int main (int argc, char *argv[])
{
  int n;
  vint V;


  /* Legge la lunghezze e gli elementi del vettore */
  LeggeVettoreInteri(&V,&n);

  /* Ordina il vettore */
  InsertionSort(V,n);

  /* Stampa il vettore ordinato */
  StampaVettoreInteri(V,n);

  /* Dealloca il vettore (anche per controllare eventuali overflow) */
  free(V);

	 return EXIT_SUCCESS;
}


/* Chiede all'utente di indicare la lunghezza e gli elementi del vettore */
void LeggeVettoreInteri (vint *pV, int *pn)
{
  int i;

  StampaStringa("Quanti numeri interi si vogliono inserire? ");
  *pn = LeggeIntero();

  *pV = (vint) calloc(*pn+1,sizeof(int));

  // Legge i numeri da tastiera
  for (i = 1; i <= *pn; i++)
  {
    StampaStringa("V[");
    StampaIntero(i);
    StampaStringa("] = ");
    (*pV)[i] = LeggeIntero();
  }
  StampaStringa("\n\n");
}


/* Stampa il vettore */
void StampaVettoreInteri (vint V, int n)
{
  int i;

  for (i = 1; i <= n; i++)
  {
    StampaIntero(V[i]);
    StampaStringa(" ");
  }
  StampaStringa("\n");
}


/* Ordina il vettore V di estremi 1 e n con l'algoritmo di Insertion Sort */
void InsertionSort (int *V, int n)
{
	int i,x,j;
	for(i=2;i<=n;i++){
		x = V[i];
		j = i;
		
		while(j>1 && V[j-1] > x){
			V[j] = V[j-1];
			j--;
		}
		V[j]=x;
	}
}



