/* fibonacci.c (Prof.Cordone)*/

#include <stdio.h>
#include <stdlib.h>
#include "iocrema.h"

#define N 40


typedef long Vector[N+1];

/* L'istruzione typedef potrebbe stare dentro il main. In tal caso, il tipo
sarebbe utilizzabile solo nel main stesso. Di solito le definizioni di 
tipo vengono però tenute globali, contrariamente a quelle delle variabili. */

int main (int argc, char *argv[])
{

  Vector Fibonacci;
  int i;
  double phi;


  /* Calcola i primi N numeri di Fibonacci e li scrive nel vettore */
  Fibonacci[0] = Fibonacci[1] = 1;
  i = 2;
  while (i <= N)
  {
    Fibonacci[i] = Fibonacci[i-1] + Fibonacci[i-2];
    i++;
  }


  /* Stampa i primi N numeri di Fibonacci */
  for (i = 0; i <= N; i++)
  {
    StampaIntero(Fibonacci[i]);
    StampaCarattere(' ',1);
  }
  StampaCarattere('\n',2);

  /* Stampa il rapporto fra numeri di Fibonacci consecutivi */
  for (i = 1; i <= N; i++)
  {
    /* Calcola il rapporto fra i numeri di Fibonacci di indice i e i-1 */
    phi = (double) Fibonacci[i]/Fibonacci[i-1]; /* sostituire 0.0 col valore del rapporto */

    StampaDouble(phi);
    StampaCarattere(' ',1);
  }
  StampaCarattere('\n',2);

	 return EXIT_SUCCESS;
}
