/* charges-sol.c (Prof.Cordone) */

#include <stdio.h>
#include <stdlib.h>
#include "iocrema.h"

#define FIX1    20.0
#define VAR1     0.0
#define FIX2    14.0
#define VAR2     0.6
#define FIX3    34.0
#define VAR3     0.4
#define FIX4   234.0
#define VAR4     0.2

#define MAX1   1000
#define MAX2  10000
#define MAX3 100000


float CalcolaCommissione (float ammontare);


int main (int argc, char *argv[])
{
  float ammontare, commissione;


  StampaStringa("Inserire la cifra da investire: ");
  ammontare = LeggeCifraDenaro();
  ACapo();

  commissione = CalcolaCommissione(ammontare);

  StampaStringa("La commissione e': ");
  StampaCifraDenaro(commissione);
  ACapo();

	 return EXIT_SUCCESS;
}


/* Calcola l'entita' della commissione */
float CalcolaCommissione (float input)
{
  float output;

  if (input <= MAX1)
    output = FIX1 + input * VAR1 / 100.0;
  else if ((MAX1 < input) && (input <= MAX2))
    output = FIX2 + input * VAR2 / 100.0;
  else if (input <= MAX3)
    output = FIX3 + input * VAR3 / 100.0;
  else
    output = FIX4 + input * VAR4 / 100.0;

  return output;
}
