#include <stdio.h>
#include <stdlib.h>

/* Stampa la stringa di caratteri "s" */
void StampaStringa (char *s)
{
  printf("%s",s);
}


/* Legge la stringa di caratteri "s" */
void LeggeStringa (char *s)
{
  scanf("%s",s);
}


/* Stampa il carattere "c" ripetuto "num" volte */
void StampaCarattere (char c, int num)
{
  int i;

  for (i = 1; i <= num; i++)
    printf("%c",c);
}


/* Va a capo */
void ACapo ()
{
  printf("\n");
}


/* Stampa il numero intero "n" */
void StampaIntero (int n)
{
  printf("%d",n);
}


/* Legge da tastiera un numero intero */
int LeggeIntero ()
{
  int res, i;

  res = scanf("%d",&i);
  if (res != 1)
  {
    fprintf(stderr,"Non si e' inserito un numero intero corretto!");
    exit(EXIT_FAILURE);
  }

  return i;
}


/* Stampa il numero naturale "n" */
void StampaNaturale (unsigned int n)
{
  printf("%u",n);
}


/* Stampa il numero long "n" */
void StampaLong (long n)
{
  printf("%ld",n);
}


/* Stampa il numero "f", reale di tipo float */
void StampaFloat (float f)
{
  printf("%f",f);
}


/* Stampa il numero "d", reale di tipo double */
void StampaDouble (double d)
{
  printf("%lf",d);
}


/* Stampa l'indirizzo "i" */
void StampaIndirizzo (void *i)
{
  printf("%p",i);
}


/* Legge da tastiera una cifra in denaro (in caso di errore, termina il programma) */
float LeggeCifraDenaro ()
{
  float f;

  if (scanf("%f",&f) != 1)
  {
    fprintf(stderr,"Non si e' inserita una cifra in denaro corretta!");
    exit(EXIT_FAILURE);
  }

  return f;
}


/* Stampa la cifra in denaro rappresentata dal numero reale "f" */
void StampaCifraDenaro (float f)
{
  printf("%.2f euro",f);
}


/* Converte una stringa numerica in un numero intero (in caso di errore, termina il programma) */
int ConverteStringaInIntero (char *s)
{
  int n;

  if (sscanf(s,"%d",&n) != 1)
  {
    StampaStringa("Il parametro non e' un numero intero!\n");
    exit(EXIT_FAILURE);
  }

  return n;
}
