/// \file solution_list.h
/// \brief Definition of data structures and functions to handle lists of solutions.
///    

#ifndef _solution_list_h
#define _solution_list_h

#include "solution.h"

SolutionList *createSolutionList ();

void destroySolutionList (SolutionList **pL);

SolutionPos *firstSolutionList (SolutionList *L);

SolutionPos *lastSolutionList (SolutionList *L);

boolean endSolutionList (SolutionPos *p, SolutionList *L);

boolean emptySolutionList (SolutionList *L);

SolutionPos *nextSolutionList (SolutionPos *p);

void insSolutionList (Solution *M, SolutionPos *p);

void cancSolutionList (SolutionPos **p);

void appendSolutionList (Solution *M, SolutionList *L);

#endif
