/// \file solution_list.c
/// \brief Declaration of data structures and functions to handle lists of solutions.
///    

#include "solution_list.h"

SolutionList *createSolutionList ()
{
  SolutionList *L = (SolutionList *) malloc(sizeof(SolutionList));
  if (L == NULL)
  {
    printf("Not enough memory to allocate a Solution list!\n");
    exit(EXIT_MEMORY);
  }
  L->next = L;
  L->prev = L;
  return L;
}


void destroySolutionList (SolutionList **pL)
{
  SolutionPos *p;
  for (p = firstSolutionList(*pL); !emptySolutionList(*pL); cancSolutionList(&p));
  *pL = NULL;
}


SolutionPos *firstSolutionList (SolutionList *L)
{
  SolutionPos *p = L->next;
  return p;
}


SolutionPos *lastSolutionList (SolutionList *L)
{
  SolutionPos *p = L->prev;
  return p;
}


boolean endSolutionList (SolutionPos *p, SolutionList *L)
{
  boolean b = (p == L);
  return b;
}


boolean emptySolutionList (SolutionList *L)
{
  boolean b = (L->next == L) && (L->prev == L);
  return b;
}


SolutionPos *nextSolutionList (SolutionPos *p)
{
  SolutionPos *M = p->next;
  return M;
}


void insSolutionList (Solution *M, SolutionPos *p)
{
  M->prev = p->prev;
  M->next = p;
  p->prev->next = M;
  p->prev = M;
}

void cancSolutionList (SolutionPos **pp)
{
  SolutionPos *M;
  M = *pp;
  M->prev->next = M->next;
  M->next->prev = M->prev;
  *pp = M->next;
  free(M);
}

void appendSolutionList (Solution *M, SolutionList *L)
{
    M->prev=L->prev;
    L->prev->next=M;
    L->prev=M;
    M->next=L;
}    
