/// \file residual_p.h
/// \brief Definition of data structures and functions to handle pointers to residuals.
///    

#ifndef _residual_p_h
#define _residual_p_h


typedef struct _p_residual_s pResidual;
typedef pResidual pResidualList;
typedef pResidual pResidualPos;

#include "residual.h"

/// \brief Data structure representing a pointer to a residual
///
/// It is used to create auxiliary lists to gather subsets or supersets of residuals
/// belonging to given solutions.
/// Quite often, we do the same by creating duplicates of the required objects 
/// (residuals, hydrogen bonds, etc...). Using a list of pointers is much more elegant:
/// in the future, this solution should be extended to all cases. However, it should 
/// also be generalized. Probably, it will be better to implement a general-purpose
/// data structure, including a pointer to void, in order to represent subsets or 
/// supersets of any given list.

struct _p_residual_s
{
  Residual  *R;   ///< Pointer to the residual referenced

  pResidual *next; ///< Pointer to the next     element in the list to which the pointer to residual belongs (NULL if none)
  pResidual *prev; ///< Pointer to the previous element in the list to which the pointer to residual belongs (NULL if none)
};

/// Create a new structure containing a pointer to a residual
pResidual *createpResidual (Residual *R);

#endif
