/// \file residual_p.c
/// \brief Declaration of data structures and functions to handle pointers to residuals.
///    

#include "residual_p.h"

pResidual *createpResidual (Residual *R)
{
  pResidual *pR = (pResidual *) malloc(sizeof(pResidual));
  if (pR == NULL)
  {
    printf("Not enough memory to allocate a pointer to a residual!\n");
    exit(EXIT_MEMORY);
  }

  pR->R = R;
  pR->next = pR->prev = NULL; 

  return pR;
}
