/// \file cluster_list.h
/// \brief Definition of data structures and functions to handle lists of clusters.
///    

#ifndef _cluster_list_h
#define _cluster_list_h

#include "cluster.h"

ClusterList *createClusterList ();

void destroyClusterList (ClusterList **pL);

ClusterPos *firstClusterList (ClusterList *L);

ClusterPos *lastClusterList (ClusterList *L);

boolean endClusterList (ClusterPos *p, ClusterList *L);

boolean emptyClusterList (ClusterList *L);

ClusterPos *nextClusterList (ClusterPos *p);

void insClusterList (Cluster *C, ClusterPos *p);

void cancClusterList (ClusterPos **p);

void appendClusterList (Cluster *C, ClusterList *L);

#endif
